#include "Param.h"

using namespace std;



Param::Param(){
    parameters = "";
    paceMode = "";
    LowerRateLimit = 0; //
    UpperRateLimit = 0; //
    MaximumSensorRate = 0; //
    FixedAVDelay = 0; //
    DynamicAVDelay = ""; //
    MinimumDynamicAVDelay = 0; //
    SensedAVDelayOffset = 0; //
    APulsedAmplitudeRegulated = 0.0; //
    VPulseAmplitudeRegulated = 0.0; //
    APulseAmplitudeUnregulated = 0.0; //
    VPulseAmplitudeUnregulated = 0.0; //
    APulseWidth = 0.0; //
    VPulseWidth = 0.0; //
    ASensitivity = 0.0; //
    VSensitivity = 0.0; //
    AtrRP = 0; //
    VentRP = 0; //
    PVARP = 0; //
    PVARPExt = 0; //
    HysteresisRateLimit = 0; //
    RateSmoothing = 0; //
    ATRMode = ""; //
    ATRDuration = 0; //
    ATRFallbackTime = 0; //
    VentricularBlanking = 0; //
    ActivityThreshold = ""; //
    ReactionTime = 0; //
    ResponseFactor = 0; //
    RecoveryTime = 0; //
    
    string nominal = "$OFF,60,120,120,150,OFF,50,OFF,3.50,3.50,3.75,3.75,0.40,0.40,0.75,2.50,320,250,250,OFF,OFF,OFF,OFF,20,1,40,Med,30,8,5,*";
    strDissect(nominal);
}

Param::Param(string params){
    parameters = "";
    paceMode = "";
    LowerRateLimit = 0; //
    UpperRateLimit = 0; //
    MaximumSensorRate = 0; //
    FixedAVDelay = 0; //
    DynamicAVDelay = ""; //
    MinimumDynamicAVDelay = 0; //
    SensedAVDelayOffset = 0; //
    APulsedAmplitudeRegulated = 0.0; //
    VPulseAmplitudeRegulated = 0.0; //
    APulseAmplitudeUnregulated = 0.0; //
    VPulseAmplitudeUnregulated = 0.0; //
    APulseWidth = 0.0; //
    VPulseWidth = 0.0; //
    ASensitivity = 0.0; //
    VSensitivity = 0.0; //
    AtrRP = 0; //
    VentRP = 0; //
    PVARP = 0; //
    PVARPExt = 0; //
    HysteresisRateLimit = 0; //
    RateSmoothing = 0; //
    ATRMode = ""; //
    ATRDuration = 0; //
    ATRFallbackTime = 0; //
    VentricularBlanking = 0; //
    ActivityThreshold = ""; //
    ReactionTime = 0; //
    ResponseFactor = 0; //
    RecoveryTime = 0; //
    
    strDissect(params);
}

void Param::concatination(){
    
    setParameters("$" +
        getMode() + "," +
        to_string(getLowerRateLimit()) + "," +
        to_string(getUpperRateLimit()) + "," +
        to_string(getMaximumSensorRate()) + "," +
        to_string(getFixedAVDelay()) + "," +
        getDynamicAVDelay() + "," +
        to_string(getMinimumDynamicAVDelay()) + "," +
        to_string(getSensedAVDelayOffset()) + "," +
        to_string(getAPulsedAmplitudeRegulated()) + "," +
        to_string(getVPulseAmplitudeRegulated()) + "," +
        to_string(getAPulseAmplitudeUnregulated()) + "," +
        to_string(getVPulseAmplitudeUnregulated()) + "," +
        to_string(getAPulseWidth()) + "," +
        to_string(getVPulseWidth()) + "," +
        to_string(getASensitivity()) + "," +
        to_string(getVSensitivity()) + "," +
        to_string(getVentRP()) + "," +
        to_string(getAtrRP()) + "," + 
        to_string(getPVARP()) + "," + 
        to_string(getPVARPExt()) + "," + 
        to_string(getHysteresisRateLimit()) + "," + 
        to_string(getRateSmoothing()) + "," + 
        getATRMode() + "," + 
        to_string(getATRDuration()) + "," + 
        to_string(getATRFallbackTime()) + "," + 
        to_string(getVentricularBlanking()) + "," + 
        getActivityThreshold() + "," + 
        to_string(getReactionTime()) + "," + 
        to_string(getResponseFactor()) + "," + 
        to_string(getRecoveryTime()) + ",*");
  
    return;

}

int Param::str_to_int(string input){
    int output;
    stringstream ss;
    
    ss << input;
    ss >> output;
    
    return output;    
}

double Param::str_to_double(string input){
    double output;
    stringstream ss;
    
    ss << input;
    ss >> output;
    
    return (output/100);    
}

string Param::to_string(int input){
    string output;
    stringstream ss;
    
    ss << input;
    ss >> output;
    
    return output;
}

string Param::to_string(double input){
    string output;
    stringstream ss;
    
    ss << (100*input);
    ss >> output;
    
    return output;
}


void Param::strDissect(string masterString) {
    
    string str = masterString; //copy of input master string
    int i = 0; //Character index parameter
    int j = 0; //Parameter index

    string temp = "";

    //check if initiator character is present
    if (str[i++] == '$') {
        //red = 1;
        //green = 1;
        //blue = 0;
        //wait (1);
        //check if final terminator character has been reached
        while (str[i] != '*') {
            //ed = 0;
            //green = 1;
            //blue = 1;
            //wait (1);
            //check if string terminator character has been reached
            for (temp = ""; str[i] != ',';i++) {
                if(str[i] == '.'||(str[i]=='0'&&((str[i+1]=='.'||str[i-1]=='.')&&(str_to_int(temp) == 0)))){
                    continue;// cases with a leading 0 or no tenths digit
                } else {
                    temp += str[i]; //add character to temp string
                    //red = !red;
                    //wait_ms(50);
                }
            }//end for
            
            //blue = 0;
            //red = 1;
            //wait(1);
            paramSet(j,temp);
            
            i++; //increase char index
            j++; //increase param index
        }//end while
    }//end if
    else {
        //request send again??
    }//end else
    concatination();
}//end strDissect


void Param::paramSet(int index, string inParam){
    string select = "- Select -";
    if(strcmp(select.c_str(),inParam.c_str())==0){
        inParam = "0";
        //cout << "Warning, some parameters are not set!" << endl;
    }
    switch (index+1){
        case 1:
            setMode(inParam);
            break;
        case 2:
            setLowerRateLimit(str_to_int(inParam));
            break;
        case 3:
            setUpperRateLimit(str_to_int(inParam));
            break;
        case 4:
            setMaximumSensorRate(str_to_int(inParam));
            break;
        case 5:
            setFixedAVDelay(str_to_int(inParam));
            break;
        case 6:
            setDynamicAVDelay(inParam);
            break;
        case 7:
            setMinimumDynamicAVDelay(str_to_int(inParam));
            break;
        case 8:
            if(str_to_int(inParam) == 0){
                setSensedAVDelayOffset(0);
            } else {
                setSensedAVDelayOffset(str_to_int(inParam));
            }
            break;
        case 9:
            setAPulsedAmplitudeRegulated(str_to_double(inParam));
            break;
        case 10:
            setVPulseAmplitudeRegulated(str_to_double(inParam));
            break;
        case 11:
            setAPulseAmplitudeUnregulated(str_to_double(inParam));
            break;
        case 12:
            setVPulseAmplitudeUnregulated(str_to_double(inParam));
            break;
        case 13:
            setAPulseWidth(str_to_double(inParam));
            break;
        case 14:
            setVPulseWidth(str_to_double(inParam));
            break;
        case 15:
            setASensitivity(str_to_double(inParam));
            break;
        case 16:
            setVSensitivity(str_to_double(inParam));
            break;
        case 17:
            setVentRP(str_to_int(inParam));
            break;
        case 18:
            setAtrRP(str_to_int(inParam));
            break;
        case 19:
            setPVARP(str_to_int(inParam));
            break;
        case 20:
            if(str_to_int(inParam) == 0){
                setPVARPExt(0);
            } else {
                setPVARPExt(str_to_int(inParam));
            }
            break;
        case 21:
            if(str_to_int(inParam) == 0){
                setHysteresisRateLimit(0);
            } else {
                setHysteresisRateLimit(str_to_int(inParam));
            }
            break;
        case 22:
            if(str_to_int(inParam) == 0){
                setRateSmoothing(0);
            } else {
                setRateSmoothing(str_to_int(inParam));
            }
            break;
        case 23:
            setATRMode(inParam);
            break;
        case 24:
            setATRDuration(str_to_int(inParam));
            break;
        case 25:
            setATRFallbackTime(str_to_int(inParam));
            break;
        case 26:
            setVentricularBlanking(str_to_int(inParam));
            break;
        case 27:
            setActivityThreshold(inParam);
            break;
        case 28:
            setReactionTime(str_to_int(inParam));
            break;
        case 29:
            setResponseFactor(str_to_int(inParam));
            break;
        case 30:
            setRecoveryTime(str_to_int(inParam));
            break;
        default:
            break;
    }
}

void Param::outputParam(){
    cout << getMode() << endl;
    cout << getLowerRateLimit() << endl;
    cout << getUpperRateLimit() << endl;
    cout << getMaximumSensorRate() << endl;
    cout << getFixedAVDelay() << endl;
    cout << getDynamicAVDelay() << endl;
    cout << getMinimumDynamicAVDelay() << endl;
    cout << getSensedAVDelayOffset() << endl;
    cout << getAPulsedAmplitudeRegulated() << endl;
    cout << getVPulseAmplitudeRegulated() << endl;
    cout << getAPulseAmplitudeUnregulated() << endl;
    cout << getVPulseAmplitudeUnregulated() << endl;
    cout << getAPulseWidth() << endl;
    cout << getVPulseWidth() << endl;
    cout << getASensitivity() << endl;
    cout << getVSensitivity() << endl;
    cout << getVentRP() << endl;
    cout << getAtrRP() << endl;
    cout << getPVARP() << endl;
    cout << getPVARPExt() << endl;
    cout << getHysteresisRateLimit() << endl;
    cout << getRateSmoothing() << endl;
    cout << getATRMode() << endl;
    cout << getATRDuration() << endl;
    cout << getATRFallbackTime() << endl;
    cout << getVentricularBlanking() << endl;
    cout << getActivityThreshold() << endl;
    cout << getReactionTime() << endl;
    cout << getResponseFactor() << endl;
    cout << getRecoveryTime() << endl;
}