/* 
 * File:   pacemaker.h
 * Author: Evan
 *
 * Created on December 5, 2016, 1:56 PM
 */

#ifndef CONTROL_H
#define CONTROL_H

class control{

public:
    void sendProgData();
    void sendProgData(ID input);
    void sendActivityThreshold();
    void sendATRDuration();
    void sendATREnable();
    void sendATRFallback();
    void sendAtrRP();
    void sendDynamicAVDelay();
    void sendFixedAVDelay();
    void sendHysterisisRateLimit();
    void sendLowerRateLimit();
    void sendMaximumSensorRate();
    void sendPulseWidth();
    void sendPVARP();
    void sendPVARPExt();
    void sendRateSmoothing();
    void sendReactionTime();
    void sendRecoveryTime();
    void sendRegulatedAmplitude();
    void sendResponseFactor();
    void sendSensedAVDelayOffset();
    void sendSensitivity();
    void sendUnregulatedAmplitude();
    void sendUpperRateLimit();
    void sendVentBlanking();
    void sendVentRP();
    void sendpaceMode();
    
    void getProgData(ID input);
    void getActivityThreshold();
    void getATRDuration();
    void getATREnable();
    void getATRFallback();
    void getAtrRP();
    void getDynamicAVDelay();
    void getFixedAVDelay();
    void getHysterisisRateLimit();
    void getLowerRateLimit();
    void getMaximumSensorRate();
    void getPulseWidth();
    void getPVARP();
    void getPVARPExt();
    void getRateSmoothing();
    void getReactionTime();
    void getRecoveryTime();
    void getRegulatedAmplitude();
    void getResponseFactor();
    void getSensedAVDelayOffset();
    void getSensitivity();
    void getUnregulatedAmplitude();
    void getUpperRateLimit();
    void getVentBlanking();
    void getVentRP();
    void getpaceMode();
    
    enum ID {
        P0000,
        PS001,
        PI002,
        PS003,
        PI004,
        PI005,
        PS006,
        PI007,
        PI008,
        PI009,
        PI010,
        PD011,
        PI012,
        PI013,
        PI014,
        PI015,
        PI016,
        PD017,
        PI018,
        PI019,
        PD020,
        PD021,
        PI022,
        PI023,
        PI024,
        PS025
    };
};
    


#endif  /* CONTROL_H */

