/* 
 * Title: FRDM K64F Pacemaker
 * File: main.cpp
 * Platform: mbed
 * Board: Freescale FRDM K64F
 * Authors: Josh Barkovic, Greg Barkans
 * Date: November 17, 2016
 *
 * Last Modified: November 16 2016
 * By: Josh Barkovic
 *
 * Skeleton for Assignment 2. This is not the only way to structure Assignment2. 
 * Feel free to do it your own way. Be sure to include all design decisions
 * in your Design Document. 
 
 * Submission Requirements:
 * Submit on Avenue, a Zip file containing your design document (in PDF form) 
 * and all soource code used.
 *
 */

/******************************************
 *
 *                Dependencies
 *
 ******************************************/
#include "mbed.h"
#include "rtos.h"
#include "motion.h"
#include "pinmap.h"
#include "parameters.h"
#include "pulsegenerator.h"
#include "serial.h"
#include <string>
#include <sstream>

/******************************************
 *
 *                Peripherals
 *
 ******************************************/

Serial        pc1(USBTX, USBRX);

/******************************************
 *
 *                Functions
 *
 ******************************************/
 
 
/**** Process: Setup
 * return: 
 * param: 
 * 
 * Process to be called at the beginning of main/on reset.
 */
 void setup(void) {
    setPins();
    pulsegenerator_initialize ();
    //param_initialize(recieve());
    string*       paramArray;
    //string*       test = new string[1];
    paramArray = recieve();
    while(1){
    for(int i=0;i<(sizeof(paramArray)/sizeof(paramArray));i++){
        pc1.printf("Entry %d = %s\r\n",i,paramArray[i]);
    }
    }
 }
/*=== MAIN ===*/

int main() {
    /* setup output pins */
    setup();
    
    Thread motionThread(osPriorityNormal);
    initialize_motion();
    motionThread.start(motion_thread);
    
    begin_pace();

    // main loop
    while(1) {
        wait(0.5);
    }  
}