#ifndef pulsegenerator__H
#define pulsegenerator__H


/*=== Pacing Modes ===*/
enum modes {VOO=0, AOO, VVI, VOOR, DDD};

/******************************************
* Setup the pulse generator on device startup
* Drives pulse output pins to safe values
*/
void pulsegenerator_initialize ();

/******************************************
* Set the current pacing mode
* The current pacing mode will change at an appropriate
* time in the pacing cycle. The function returns immediately
* with the previous value of current pacing mode
* Inputs: newMode - the mode to switch to
* Returns: The previous pacing mode
*/
modes set_pacing_mode (modes newMode);

/******************************************
* Set the current pace period
* Inputs: new_pace_period_ms - the pace period to switch to
* Returns: The previous pace period
*/
uint32_t set_pace_period_ms(uint32_t new_pace_period_ms);

/******************************************
* Initiates pacing. Returns immediately
*/
void begin_pace ();

#endif