#ifndef PARAMETERS_H
#define PARAMETERS_H

#include <stdint.h>
#include "mbed.h"
#include <string>


/**********************************************
 *
 *   Programmable Parameters Access Functions
 *
 **********************************************/

//void param_initialize(string* strArray);

uint16_t get_lower_rate_limit(); // # of pace pulses per minute
uint16_t get_lower_rate_limit_period_ms(); // LRL as a period in milliseconds
void set_lower_rate_limit(uint16_t lrl);

uint16_t get_upper_rate_limit(); // min t b/w vent event and next vent pace
uint16_t get_upper_rate_limit_period_ms(); // URL as a period in milliseconds
void set_upper_rate_limit(uint16_t url);

uint16_t get_max_sensor_rate(); // max rate allowed from adaptive pacing  
uint16_t get_max_sensor_rate_period_ms(); // MSR as a period in milliseconds
void set_max_sensor_rate(uint16_t msr);

uint16_t get_fixed_av_delay_ms();  // time between atrial and vent events in milliseconds
void set_fixed_av_delay_ms(uint16_t av_delay_ms);

uint16_t get_atr_pulse_width_us();  // duration of atrial pulse in microseconds
void set_atr_pulse_width_us(uint16_t atr_pulse_width);

uint16_t get_vent_pulse_width_us(); // duration of ventricular pulse in microseconds
void set_vent_pulse_width_us(uint16_t v_pulse_width_us);

uint16_t get_atr_pulse_amp(); // amplitude of atrial pulses
void set_atr_pulse_amp(uint16_t atr_pulse_amp);

uint16_t get_vent_pulse_amp(); // amplitude of ventricular pulses
void set_vent_pulse_amp(uint16_t vent_pulse_amp);

#endif