#include "parameters.h"
#include <cstdlib>

    string ActivityThreshold; //
    uint16_t ATRDuration; //
    string ATREnable; //
    uint16_t ATRFallback; //
    uint16_t AtrRP; //
    string DynamicAVDelay; //
    uint16_t FixedAVDelay; //
    uint16_t HysterisisRateLimit; //
    uint16_t LowerRateLimit; //
    uint16_t MaximumSensorRate; //
    double PulseWidth; //
    uint16_t PVARP; //
    uint16_t PVARPExt; //
    uint16_t RateSmoothing; //
    uint16_t ReactionTime; //
    uint16_t RecoveryTime; //
    double RegulatedAmplitude; //
    uint16_t ResponseFactor; //
    int SensedAVDelayOffset; //
    double Sensitivity; //
    double UnregulatedAmplitude; //
    uint16_t UpperRateLimit; //
    uint16_t VentBlanking; //
    uint16_t VentRP; //
    string Mode; //
    
//Initialize with Nominal Values 
uint16_t lower_rate_limit = 60; // # of pace pulses per minute
uint16_t lower_rate_limit_period_ms = 1000; // LRL as a period
uint16_t upper_rate_limit = 120; // min t b/w vent event and next vent pace
uint16_t upper_rate_limit_period_ms = 500; // URL as a period
uint16_t max_sensor_rate  = 120; // max rate allowed from adaptive pacing  
uint16_t max_sensor_rate_period_ms  = 500; // MSR as a period

uint16_t fixed_av_delay_ms = 150;  // time between atrial and vent events

uint16_t atr_pulse_width_us  = 400; // duration of atrial pulse in microseconds
uint16_t vent_pulse_width_us = 400; // duration of ventricular pulse in microseconds

uint16_t atr_pulse_amp  = 3500; // amplitude of atrial pulses in milliovolts
uint16_t vent_pulse_amp = 3500; // amplitude of ventricular pulses in millivolts
/*
void param_initialize(string* strArray){
    std::string::size_type sz;
    ActivityThreshold =      strArray[0];
    ATRDuration =            stoul(strArray[1],nullptr,0);
    ATREnable =              strArray[2];
    ATRFallback =            stoul(strArray[3],nullptr,0);
    AtrRP =                  stoul(strArray[4],nullptr,0);
    DynamicAVDelay =         strArray[5];
    FixedAVDelay =           stoul(strArray[6],nullptr,0);
    HysterisisRateLimit =    stoul(strArray[7],nullptr,0);
    LowerRateLimit =         stoul(strArray[8],nullptr,0);
    MaximumSensorRate =      stoul(strArray[9],nullptr,0);
    PulseWidth =             stod(strArray[10],sz);
    PVARP =                  stoul(strArray[11],nullptr,0);
    PVARPExt =               stoul(strArray[12],nullptr,0);
    RateSmoothing =          stoul(strArray[13],nullptr,0);
    ReactionTime =           stoul(strArray[14],nullptr,0);
    RecoveryTime =           stoul(strArray[15],nullptr,0);
    RegulatedAmplitude =     stod(strArray[16],sz);
    ResponseFactor =         stoul(strArray[17],nullptr,0);
    SensedAVDelayOffset =    stoi(strArray[18]);
    Sensitivity =            stod(strArray[19]);
    UnregulatedAmplitude =   stod(strArray[20]);
    UpperRateLimit =         stoul(strArray[21]);
    VentBlanking =           stoul(strArray[22]);
    VentRP =                 stoul(strArray[23]);
    Mode =                   strArray[24];
}*/

uint16_t get_lower_rate_limit() { // # of pace pulses per minute
    return lower_rate_limit;
}
uint16_t get_lower_rate_limit_period_ms() { // LRL as a period
    return lower_rate_limit_period_ms;
}
void set_lower_rate_limit(uint16_t lrl) {
    lower_rate_limit = lrl;
    lower_rate_limit_period_ms = (60000/lrl);
}

uint16_t get_upper_rate_limit() { // min t b/w vent event and next vent pace
    return upper_rate_limit;
}
uint16_t get_upper_rate_limit_period_ms() { // URL as a period
    return upper_rate_limit_period_ms;
}
void set_upper_rate_limit(uint16_t url) {
    upper_rate_limit = url;
    upper_rate_limit_period_ms = (60000/url);
}

uint16_t get_max_sensor_rate() { // max rate allowed from adaptive pacing  
    return max_sensor_rate;
}
uint16_t get_max_sensor_rate_period_ms() { // MSR as a period
    return max_sensor_rate_period_ms;
}
void set_max_sensor_rate(uint16_t msr) {
    max_sensor_rate = msr;
    max_sensor_rate_period_ms = (60000/msr);
}

uint16_t get_fixed_av_delay_ms() {  // time between atrial and vent events
    return fixed_av_delay_ms;
}
void set_fixed_av_delay_ms(uint16_t av_delay_ms) {
    fixed_av_delay_ms = av_delay_ms;
}

uint16_t get_atr_pulse_width_us() { // duration of atrial pulse
    return atr_pulse_width_us;
}
void set_atr_pulse_width_us(uint16_t atr_pulse_width) {
    atr_pulse_width_us = atr_pulse_width;
}

uint16_t get_vent_pulse_width_us() { // duration of ventricular pulse in microseconds
    return vent_pulse_width_us;
}
void set_vent_pulse_width_us(uint16_t v_pulse_width_us) {
    vent_pulse_width_us = v_pulse_width_us;
}

uint16_t get_atr_pulse_amp() { // amplitude of atrial pulses
    return atr_pulse_amp;
}
void set_atr_pulse_amp(uint16_t atr_pulse_amp) {
    atr_pulse_amp = atr_pulse_amp;
}

uint16_t get_vent_pulse_amp() { // amplitude of ventricular pulses
    return vent_pulse_amp;
}
void set_vent_pulse_amp(uint16_t vent_pulse_amp) {
    vent_pulse_amp = vent_pulse_amp;
}