#include "rtos.h"
#include "pinmap.h"
#include "FXOS8700Q.h"
#include "motion.h"


FXOS8700Q_acc acc(PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1);

/* Constants and Declares */
int numCount;
int const MAX_NUM_COUNTS = 3;
int const TIMING_PERIOD = 1; // Sensor polling interval
int events [30];

uint8_t motion_exceeded_threshold = 0;

void initialize_motion () {
    acc.enable();
}

bool isMotionThresholdExceeded () {
    return motion_exceeded_threshold;    
}

float getAcceleration(){
    float xAcc, yAcc, zAcc;
    acc.getX(&xAcc);
    acc.getY(&yAcc);
    acc.getZ(&zAcc);
    float magtd = xAcc*xAcc + yAcc*yAcc + zAcc*zAcc;
    return magtd;
}
    

void resetMotionDetection () {
    motion_exceeded_threshold = 0;
}

/**** Function: a_count
 * return: void
 * parameters: none
 * A function called if motion detection interrupt flag is set.  Maintains
 * a global counter and sets a timer to keep track of number of flags within
 * timing limit.
 */ 
void a_count(void) {
    /* step 1 increment the counter */
    numCount = sumArray();
    

    if (numCount >= MAX_NUM_COUNTS) {
        rled = !rled;   // toggle LEDs to show acceleration threshold reached
        gled = !gled;   // toggle LEDS to show acceleration threshold reached
        
        motion_exceeded_threshold = 1;
    }
}

void motion_thread () {
    while(true) {
        float xAcc, yAcc, zAcc;
        acc.getX(&xAcc);
        acc.getY(&yAcc);
        acc.getZ(&zAcc);
        float magtd = xAcc*xAcc + yAcc*yAcc + zAcc*zAcc;
        
        if (magtd > 3.0f) { // Greater than (1.5G of Accel.)^2
            addEvent(1);
            a_count();      // increment acceleration event counter
        }else{
            addEvent(0);
        }

        Thread::wait(TIMING_PERIOD); 
    }   
}

void addEvent(int input){
    for(int i=29; i >= 1;i--){
        events[i]=events[i-1];
    }
    events[0]=input;    
}

int sumArray(){
    int sum=0;
    for(int i=0;i<=29;i++){
        sum += events[i];        
    }    
    return sum;
}