#include "control.h"
#include <iostream>
#include <sstream>
#include "parameters.h"
#include "serial.h"

using namespace std;

    //SERIAL SENDER
    void control::sendProgData(){
        control::sendActivityThreshold();
        control::sendATRDuration();
        control::sendATREnable();
        control::sendATRFallback();
        control::sendAtrRP();
        control::sendDynamicAVDelay();
        control::sendFixedAVDelay();
        control::sendHysterisisRateLimit();
        control::sendLowerRateLimit();
        control::sendMaximumSensorRate();
        control::sendPulseWidth();
        control::sendPVARP();
        control::sendPVARPExt();
        control::sendRateSmoothing();
        control::sendReactionTime();
        control::sendRecoveryTime();
        control::sendRegulatedAmplitude();
        control::sendResponseFactor();
        control::sendSensedAVDelayOffset();
        control::sendSensitivity();
        control::sendUnregulatedAmplitude();
        control::sendUpperRateLimit();
        control::sendVentBlanking();
        control::sendVentRP();
        control::sendpaceMode();
    }
    
    void control::sendProgData(control::ID input){
        switch(input){
            case control::P0000:
                break;
            case control::PS001:
                control::sendActivityThreshold();
                break;
            case control::PI002:
                control::sendATRDuration();
                break;
            case control::PS003:
                control::sendATREnable();
                break;
            case control::PI004:
                control::sendATRFallback();
                break;
            case control::PI005:
                control::sendAtrRP();
                break;
            case control::PS006:
                control::sendDynamicAVDelay();
                break;
            case control::PI007:
                control::sendFixedAVDelay();
                break;
            case control::PI008:
                control::sendHysterisisRateLimit();
                break;
            case control::PI009:
                control::sendLowerRateLimit();
                break;
            case control::PI010:
                control::sendMaximumSensorRate();
                break;
            case control::PD011:
                control::sendPulseWidth();
                break;
            case control::PI012:
                control::sendPVARP();
                break;
            case control::PI013:
                control::sendPVARPExt();
                break;
            case control::PI014:
                control::sendRateSmoothing();
                break;
            case control::PI015:
                control::sendReactionTime();
                break;
            case control::PI016:
                control::sendRecoveryTime();
                break;
            case control::PD017:
                control::sendRegulatedAmplitude();
                break;
            case control::PI018:
                control::sendResponseFactor();
                break;
            case control::PI019:
                control::sendSensedAVDelayOffset();
                break;
            case control::PD020:
                control::sendSensitivity();
                break;
            case control::PD021:
                control::sendUnregulatedAmplitude();
                break;
            case control::PI022:
                control::sendUpperRateLimit();
                break;
            case control::PI023:
                control::sendVentBlanking();
                break;
            case control::PI024:
                control::sendVentRP();
                break;
            case control::PS025:
                control::sendpaceMode();
                break;
        }
        
    }
    void control::sendActivityThreshold(){
        
    }
    void control::sendATRDuration(){
        
    }
    void control::sendATREnable(){
        
    }
    void control::sendATRFallback(){
        
    }
    void control::sendAtrRP(){
        
    }
    void control::sendDynamicAVDelay(){
        
    }
    void control::sendFixedAVDelay(){
        
    }
    void control::sendHysterisisRateLimit(){
        
    }
    void control::sendLowerRateLimit(){
        
    }
    void control::sendMaximumSensorRate(){
        
    }
    void control::sendPulseWidth(){
        
    }
    void control::sendPVARP(){
        
    }
    void control::sendPVARPExt(){
        
    }
    void control::sendRateSmoothing(){
        
    }
    void control::sendReactionTime(){
        
    }
    void control::sendRecoveryTime(){
        
    }
    void control::sendRegulatedAmplitude(){
        
    }
    void control::sendResponseFactor(){
        
    }
    void control::sendSensedAVDelayOffset(){
        
    }
    void control::sendSensitivity(){
        
    }
    void control::sendUnregulatedAmplitude(){
        
    }
    void control::sendUpperRateLimit(){
        
    }
    void control::sendVentBlanking(){
        
    }
    void control::sendVentRP(){
        
    }
    void control::sendpaceMode(){
        
    }
    
    
    //SERIAL ACCESSOR
    void control::getProgData(){
        control::getActivityThreshold();
        control::getATRDuration();
        control::getATREnable();
        control::getATRFallback();
        control::getAtrRP();
        control::getDynamicAVDelay();
        control::getFixedAVDelay();
        control::getHysterisisRateLimit();
        control::getLowerRateLimit();
        control::getMaximumSensorRate();
        control::getPulseWidth();
        control::getPVARP();
        control::getPVARPExt();
        control::getRateSmoothing();
        control::getReactionTime();
        control::getRecoveryTime();
        control::getRegulatedAmplitude();
        control::getResponseFactor();
        control::getSensedAVDelayOffset();
        control::getSensitivity();
        control::getUnregulatedAmplitude();
        control::getUpperRateLimit();
        control::getVentBlanking();
        control::getVentRP();
        control::getpaceMode();
    }
    
    void control::getProgData(control::ID input){
        switch(input){
            case control::P0000:
                break;
            case control::PS001:
                control::getActivityThreshold();
                break;
            case control::PI002:
                control::getATRDuration();
                break;
            case control::PS003:
                control::getATREnable();
                break;
            case control::PI004:
                control::getATRFallback();
                break;
            case control::PI005:
                control::getAtrRP();
                break;
            case control::PS006:
                control::getDynamicAVDelay();
                break;
            case control::PI007:
                control::getFixedAVDelay();
                break;
            case control::PI008:
                control::getHysterisisRateLimit();
                break;
            case control::PI009:
                control::getLowerRateLimit();
                break;
            case control::PI010:
                control::getMaximumSensorRate();
                break;
            case control::PD011:
                control::getPulseWidth();
                break;
            case control::PI012:
                control::getPVARP();
                break;
            case control::PI013:
                control::getPVARPExt();
                break;
            case control::PI014:
                control::getRateSmoothing();
                break;
            case control::PI015:
                control::getReactionTime();
                break;
            case control::PI016:
                control::getRecoveryTime();
                break;
            case control::PD017:
                control::getRegulatedAmplitude();
                break;
            case control::PI018:
                control::getResponseFactor();
                break;
            case control::PI019:
                control::getSensedAVDelayOffset();
                break;
            case control::PD020:
                control::getSensitivity();
                break;
            case control::PD021:
                control::getUnregulatedAmplitude();
                break;
            case control::PI022:
                control::getUpperRateLimit();
                break;
            case control::PI023:
                control::getVentBlanking();
                break;
            case control::PI024:
                control::getVentRP();
                break;
            case control::PS025:
                control::getpaceMode();
                break;
        }
        
    }
  /*  void control::getActivityThreshold(){
        setActivityThreshold(receive());
    }
    void control::getATRDuration(){
        setATRDuration(atoi(receive()));
    }
    void control::getATREnable(){
        setATREnable(receive());
    }
    void control::getATRFallback(){
        setATRFallback((receive()));
    }
    void control::getAtrRP(){
        setAtrRP((receive()));
    }
    void control::getDynamicAVDelay(){
        setDynamicAVDelay(receive());
    }
    void control::getFixedAVDelay(){
        setFixedAVDelay((recieve()));
    }
    void control::getHysterisisRateLimit(){
        setHysterisisRateLimit((recieve()));
    }
    void control::getLowerRateLimit(){
        setLowerRateLimit(stoi(recieve()));
    }
    void control::getMaximumSensorRate(){
        setMaximumSensorRate(stoi(recieve()));
    }
    void control::getPulseWidth(){
        setPulseWidth(stod(recieve()));
    }
    void control::getPVARP(){
        setPVARP(stoi(recieve()));
    }
    void control::getPVARPExt(){
        setPVARPExt(stoi(recieve()));
    }
    void control::getRateSmoothing(){
        setRateSmoothing(stoi(recieve()));
    }
    void control::getReactionTime(){
        setReactionTime(stoi(recieve()));
    }
    void control::getRecoveryTime(){
        setRecoveryTime(stoi(recieve()));
    }
    void control::getRegulatedAmplitude(){
        setRegulatedAmplitude(stod(recieve()));
    }
    void control::getResponseFactor(){
        setResponseFactor(stoi(recieve()));
    }
    void control::getSensedAVDelayOffset(){
        setSensedAVDelayOffset(stoi(recieve()));
    }
    void control::getSensitivity(){
        setSensitivity(stod(recieve()));
    }
    void control::getUnregulatedAmplitude(){
        setUnregulatedAmplitude(stod(recieve()));
    }
    void control::getUpperRateLimit(){
        setUpperRateLimit(stoi(recieve()));
    }
    void control::getVentBlanking(){
        setVentBlanking(stoi(recieve()));
    }
    void control::getVentRP(){
        setVentRP(stoi(recieve()));
    }
    void control::getpaceMode(){
        setpaceMode(recieve());
    } */
