/*-----NEW PROJECT-----*/
/*Bisogna realizzare utilizzando la scheda ST nucleo F401RE un dispositivo che succesivamente verrà montato su varie macchine presenti
nel laboratorio di affidabilità.
Il compito di tale dispositivo è quello di verificare se la macchina sta lavorando oppure no e comunicare all'operatore lo stato della
macchina. 
Per fare ciò il dipositivo viene collegato a un rele presente nella macchina. La scheda st deve verifiare lo stato di tale rele e comunicare
all'operatore attraverso una shield ethernet lo stato della macchina.
Il dispositivo lavora solo a macchina accesa.*/

/*gli stati che può assumere la macchina sono due:
- RUN macchina accesa e operativa
- IDLE macchina accesa ma non operativa*/


/*-----LIBRERIE-----*/
    #include "mbed.h"
/*-----------------*/

/*-----COSTANTI-----*/
    #define MIN_CONT 30 //specifico il numero di volte che ripeterò il processo di verifica dello stato del bottone/rele
    
    #define TIME 100
    
    #define NORMAL_OPEN 0 //specifico un valore da dare allo stato fisico "normalmente aperto"
    
    #define NORMAL_CLOSE 1 //specifico un valore da dare allo stato fisico "normalmente chiuso"
    
    /*a seconda del caso devo decidere se lo stato di RUN corrisponde allo stato fisico "normalmente aperto" oppure
      "normalmente chiuso" specificandolo qui sotto*/
    #define RUN NORMAL_OPEN //<---
/*------------------*/

/*-----VARIABILI-----*/
    DigitalIn button(USER_BUTTON); //istanzio oggetto "button" per utilizzare il bottone/rele
    
    DigitalOut myled(D11); //istanzio ogetto "myled" per gestire l'accensione e lo spegnimento di un led
    
    /*variabili intere dove conto per quante volte di seguito lo stato del bottone/rele rimane uguale.
      Se lo stato del bottone/rele è in RUN allora aumento la variabile "contRun", al contrario aumento la variabile 
      "contIdle" */
    int contRun = 0, contIdle = 0;
    
    /*flag che mi impediscono di comunicare lo stesso risultato più volte. Una volta comunicato lo stato di RUN
      il flag dedicato (flagRun) passerà al valore "false" e non potrà più essere comunicato lo stato RUN prima
      di ripassare dallo stato IDLE, idem dopo la comunicazione dello stato IDLE*/
    bool flagRun = true, flagIdle = true;
/*-------------------*/

int main() {
    
    while(true) { //attivo un ciclo infinito
        if( button == RUN ){ //stato RUN
            contRun++; //aumento di 1 la variabile "contRun"
            contIdle = 0; /*una volta ritornato nello stato di RUN setto a 0 la variabile "contaIdle" in modo da
                            ripartire da capo una volta tornato in stato IDLE*/
                            
            /*una volta che la variabile "contaRun" raggiunge un valore minimo fissato dalla costate MIN_CONT allora considero
              lo stato di RUN come attendibile e lo posso comunicare a utente.
              dopo averlo comunicato la prima volta il "flagRun" passa al valore "false" e non verrà ritrasmesso prima di
              passare nuovamente allo stato IDLE*/
            if( contRun >= MIN_CONT && flagRun ){ 
                flagRun = false; //setto "flagRun" a "false"
                flagIdle = true; //setto "flagIdle" a "true"
                myled = 1; /*comunico a utente che la macchina è in stato di RUN con l'accensione di un led.
                             Successivamente lo stato sarà comunicato al PC utilizzando una scheda di rete*/
            }
        }   
        else{ //stato IDLE, funzionamento logico uguale allo stato RUN
            contRun = 0;
            contIdle++;
            if( contIdle >= MIN_CONT && flagIdle ){
                flagRun = true;
                flagIdle = false;
                myled = 0;
            }
        }
        wait_ms(TIME); //tra una lettura del bottone/rele e l'altra attendo un TOT tempo specificato nella costante TIME
    }
}