/*il modulo infrarossi ha tre uscite:
attaccate le uscite opportune a VCC e GND mentre la terza uscita al pin analogico che corrisponde
a quello della costante ANALOG_PIN ( in questo caso A5 )*/

#include "mbed.h"
#define ANALOG_PIN A5

int read_distance();

AnalogIn infrared(ANALOG_PIN);
DigitalOut led(D11);

Serial pc(USBTX, USBRX);

int main() {
    
    pc.baud(9600);
    int distance;
    while(1){
        distance = read_distance();
        printf("distance: %d/n/r", distance);
        if( distance <= 30 )
            led = 1;
        else
            led = 0;
    }
    
}

int read_distance()
{
    float volts = infrared.read() * 0.0048828125; /* il valore indica il risultato dell' operazione 5/1024, moltiplico il valore letto
                                                     per tale valore per porlo su una scala di massimo 5 volt */
    
    return volts * pow(volts, -1); //la distaza ritornata e' in centimetri   
}