/****************************************************
*            FAST PROTOTYPING WITH NUCLEO           *
* Example Code 13: Ultrasound HCSR04                *
* Author: Mauro D'Angelo                            *
* Organization: Perlatecnica no-profit organization *  
*****************************************************/

#include "mbed.h"
#include "hcsr04.h"
#include "rtos.h"

// Instanzio un oggetto di tipo HCSR04 ed assegno i pin di trigger e di echo 
HCSR04 sensor(PB_8, PB_9);
HCSR04 sensor1(PA_5, PA_6);

DigitalOut led(D11);

// Serial
Serial pc(USBTX, USBRX);

int distanza;

void thread(void const *args) {
    // Main loop
    while(1) {
        // Avvia un impulso della durata di 10us sul pin di trigger
        sensor.start();
        
        // Aspetta prima della prossima lettura
        wait_ms(100); 
        
        // Stampa sulla seriale la misura della distanza in cm
        distanza = sensor.get_dist_cm();
        pc.printf("%dcm\r\n", distanza);
    }
}
 
int main() {
    // Fisso il baudrate
    pc.baud(9600);
    
    Thread th(thread); // Threads start here
     
    while(1){
        if(distanza < 20)
            led = 1;
        else
            led = 0;
    }
}

