#include "hcsr04.h"


/* mbed specific header files. */
#include "mbed.h"

/* Helper header files. */
#include "DevSPI.h"

/* Component specific header files. */
#include "L6474.h"


/* Number of steps. */
#define STEPS 3200

/* Delay in milliseconds. */
#define DELAY_1 2000
#define DELAY_2 6000
#define DELAY_3 8000

/* Speed in pps (Pulses Per Second).
   In Full Step mode: 1 pps = 1 step/s).
   In 1/N Step Mode:  N pps = 1 step/s). */
#define SPEED_1 2400
#define SPEED_2 1200



/* Motor Control Component. */

L6474 *motor1;
HCSR04 sensor(PB_8, PB_9);
int distanza;


/* Initializing SPI bus. */
 DevSPI dev_spi(D11, D12, D13);
 DigitalOut led(D11);
  /* Initializing Motor Control Components. */

   

 void thread(void const *args) {
    
while (1)
    {
          
        // Avvia un impulso della durata di 10us sul pin di trigger
        sensor.start();
        
        // Aspetta prima della prossima lettura
        wait_ms(100); 
        
        // Stampa sulla seriale la misura della distanza in cm
        distanza = sensor.get_dist_cm();
        }
          if(distanza > 10)
            motor1->run(StepperMotor::FWD);
        else
            led = 0;
        }
           
    







    

    
   

   
   

