/*---programma per simulare uscita del sensore sonoro---*/
/*il sensore sonoro si andra ad agganciare solo a una parte del suono della sirena,
la porzione a frequenza 1kHez, quindi il programma ricevera segnali variabili come:
SEQUENZA SEGNALI ALTI + SEQUENZA SEGNALI BASSI + SEQUENZA SEGNALI ALTI...

il programma simula questo tipo di uscita*/

/*utilizzando lo user button attivo e disattivo la sirena (led on sirena accesa, led off spenta)*/

#include "mbed.h"
#include "rtos.h"

void check_sirena_thread();

DigitalOut myled(D8);

DigitalOut check(D11);

DigitalIn button1(USER_BUTTON);

bool button = true;

Serial pc(USBTX, USBRX); //istanzio oggetto per utilizzo monitor seriale

int main() {
    
    int conta = 0, mod = 0;
    
    Thread sirenaThread(check_sirena_thread); // start Thread controllo sirena
    
    while(true) {
        while(button) {
            if( mod % 2 == 0 )
                myled = 1;
            else
                myled = 0;
            conta++;
            if( conta == 500 ){
                mod++;
                conta = 0;
            }
            wait_ms(1);
        }
        myled = 0;
    }
}

void check_sirena_thread()
{
    int val, conta2 = 0;
    while(true) {
        val = button1.read();
        if( val == 0 )
            conta2++;
        while(button1.read() == 0);
        //pc.printf("recived: %d \r\n",conta2); //stampa a video
        if( conta2 % 2 == 1 ){
            button = true;
            check = 1;
        }
        else{
            button = false;
            check = 0;
        }
    }
}