/*
   This VL6180X Expansion board test application performs a range measurement
   and als measurement in polling mode on the onboard embedded top sensor. 
   The result of both the measures are printed on the serial over.  
   get_distance() and get_lux() are synchronous! They block the caller until the
   result will be ready.
*/


/* Includes ------------------------------------------------------------------*/

#include "mbed.h"
#include "XNucleo6180XA1.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>


/* Definitions ---------------------------------------------------------------*/

#define VL6180X_I2C_SDA   D14 
#define VL6180X_I2C_SCL   D15 


/* Variables -----------------------------------------------------------------*/

static XNucleo6180XA1 *board = NULL;


/* Functions -----------------------------------------------------------------*/

/*=================================== Main ==================================
  Prints on the serial over USB the measured distance and lux.
  The measures are run in single shot polling mode.
=============================================================================*/
int main()
{ 
	int status;
	uint32_t lux, dist;
	DevI2C *device_i2c = new DevI2C(VL6180X_I2C_SDA, VL6180X_I2C_SCL);

	/* Creates the 6180XA1 expansion board singleton obj. */
	board = XNucleo6180XA1::instance(device_i2c, A3, A2, D13, D2);

	/* Initializes the 6180XA1 expansion board with default values. */
	status = board->init_board();
	if (status) {
		printf("Failed to init board!\n\r");
		return 0;
	}

	while (true) {
		board->sensor_top->get_distance(&dist);
		board->sensor_top->get_lux(&lux);
		printf ("Distance: %d, Lux: %d\n\r", dist, lux);
	}
}
