#include "mbed.h"
#include "USBKeyboard.h"
#include "MMA7660.h"
#include "C12832.h"


MMA7660         Accelerometer (p28,p27);        //define accelerometer
USBKeyboard     Usbkeyboard;                    //define keyboard
C12832          LCD (p5,p7,p6,p8,p11);          //define LCD
DigitalOut led1(p12);                           //leds
DigitalOut led2(p13);
DigitalOut led3(p14);
DigitalOut led4(p15);

DigitalIn  Switch1 (p8);                          //switch mode 1 (arrows) and 2 (letters)
DigitalIn  Switch2 (p16);                         //switch to numbers
DigitalIn  Switch3 (p17);                         //enter
DigitalIn  Switch4 (p18);                         //spacebar

int main (void)                                                     //main program
{
                                                                    //enum Orientation {Up, Down,Right, Left,Back, Front,Unknown};
        MMA7660::Orientation myOrientation;                         //defining orientation
        
        while (true) {
            
                
                myOrientation = Accelerometer.getOrientation ();    //getting the orientation from accelerometer
          
          
           if (Switch4){
                    
                    Usbkeyboard.printf (" ");                       //spacebar
                    
                       }
                       
           if (Switch3){
                    
                    Usbkeyboard.keyCode (RIGHT_ARROW);              //enter will be HERE
                                 
                       }
                
           if (Switch1){                                             //if the switch is on
                
                if (myOrientation == MMA7660::Up){                  //if the orientation is up
                
                    LCD.printf("Left");                             //print "left" on LCD (due to orientation of the accelerometer on the limb, the directions are changed) 
                    Usbkeyboard.keyCode (LEFT_ARROW);               //device simulates pressing "left arrow key" on the keyboard
                    led2=0;                                         //led off
                    led1=0;                                         //led off
                    led3=0;                                         //led off
                    led4=1;                                         //led on
                }
                else if (myOrientation == MMA7660::Down){
                
                    LCD.printf("Right");
                    Usbkeyboard.keyCode (RIGHT_ARROW);
                    led3=0;
                    led1=0;
                    led2=1;
                    led4=0;
                }
                else if (myOrientation == MMA7660::Left){
                
                    LCD.printf("UP");
                    Usbkeyboard.keyCode (UP_ARROW);
                    led1=1;
                    led3=0;
                    led2=0;
                    led4=0;
                }
                else if (myOrientation == MMA7660::Right){
                
                    LCD.printf("DOWN");
                    Usbkeyboard.keyCode (DOWN_ARROW);
                    led4=0;
                    led1=0;
                    led3=1;
                    led2=0;
                               
                    
                }
                else if (myOrientation == MMA7660::Unknown){
                
                 LCD.printf("Don't Know");
                 
                }
            }
            
            else {                                                  //if the switch is off than
               
               if (myOrientation == MMA7660::Up){
                
                    LCD.printf("LEFT");
                    Usbkeyboard.printf ("a\0");                     //instead of simulating pressing of the "left arrow", simulates pressing "a key"
                    led2=0;
                    led1=0;
                    led3=0;
                    led4=1;
                }
                else if (myOrientation == MMA7660::Down){
                
                    LCD.printf("right");
                    Usbkeyboard.printf ("d\0");
                    led3=0;
                    led1=0;
                    led2=1;
                    led4=0;
                }
                else if (myOrientation == MMA7660::Left){
                
                    LCD.printf("Up");
                    Usbkeyboard.printf ("w\0");
                    led1=1;
                    led3=0;
                    led2=0;
                    led4=0;
                }
                else if (myOrientation == MMA7660::Right){
                
                    LCD.printf("Down");
                    Usbkeyboard.printf ("s\0");
                    led4=0;
                    led1=0;
                    led3=1;
                    led2=0;
                
                    
                    
                }
                else if (myOrientation == MMA7660::Unknown){
                
                 LCD.printf("Don't Know");
                 
                } 
                
            }
         

        }
    return false;
}
