#include "mbed.h"
#include <iostream>
#include <math.h> 
#define TI  .001f       //1kHz sample time
#define dKP  5.1491f     //Proportional Gain
#define dKI  119.3089f   //Integral Gain
#define FPWM .000034f    //PWM Frequency#define TI 0.001 //1kHz sample time
#define sKP 5.375f//5.50f //Proportional Gain
#define sKD 0.003f //Derivative Gain was .01
#define sKI 0.025f//0.001f//0.0001f //Derivative Gain was .01
#define ssKP 1.0f
#define ssKD 0.001f
#define ssKI 0.001f
#define DCINTERCEPT 0.06f //duty cycle intercept was 0.061
#define DCSLOPE 0.03f //duty cycle slope was .05
#define TOL 0.005f               //tolerance
#define LEDOFF 0.0f
#define LEDON 1.0f
#define RATIO 3.9625f
#ifndef M_PI
#define M_PI 3.14f
#endif
#define MIN -40.0*(M_PI/180)
#define MAX -40.0*(M_PI/180)

#define BLUETOOTHBAUDRATE 115200 //Communication rate of the micro-controller
                                 //to the Bluetooth module
#define SERIALTXPORT PTE0 //Tx Pin (Sends information to serial device)
#define SERIALRXPORT PTE1 //Rx Pin (Receives information from serial
Serial bt(SERIALTXPORT, SERIALRXPORT); //(TX, RX) Serial 
//Pins
PwmOut led_red(LED1);
PwmOut led_blue(LED3);
PwmOut led_green(LED2);

AnalogIn _SpeedReference(A0);
AnalogIn _Tacho(A1);
PwmOut _MotorControl(PTD0);
DigitalOut _BreakSignal(PTC9);//D5

AnalogIn _LeftSensors(A2);
AnalogIn _RightSensors(A3);
PwmOut _servo(PTE20);//A13

//Binary LED
DigitalOut _FirstBinaryLED(A5);
DigitalOut _SecondBinaryLED(PTE21);
DigitalOut _ThirdBinaryLED(PTD2);
DigitalOut _FourthBinaryLED(PTE31);
//Hardware Interupts
Ticker Update;
Ticker sUpdate;
Ticker loopUpdate;
DigitalIn _RunButton(PTA4);
DigitalIn _StopButton(PTA5);
DigitalIn _BumperStop(PTD3);
AnalogIn _BattMon(A4);

InterruptIn arrowheadLeft(PTD5);//PTA1
InterruptIn arrowheadRight(PTA13);//PTA2


//Integral Value 
float _errorArea;
float _error;
float _controllerOutput;
float _steeringArea;
float _ref;
float _feedbackPrev;
int _counter = 0;
bool _ArrowHitRight;
bool _ArrowHitLeft;
float _steeringControllerOut;
float _dutyCycle;



//States
enum States {RUN, WAIT, STOP, EMPTY};
States _NextState;
States _CurrentState;

//Methods
void Init();
void Loop();
void UpdateMethod();
void UpdateDriveControl();
void UpdateSteeringControl();
void UpdateLowBatteryStop();
void UpdateLoop();
void SetMotor(float);
void BreaksOn();
void BreaksOff();
void StopMethod();
void WaitMethod();
void RunMethod();
void RunButtonMethod();
void StopButtonMethod();
void BumperStopMethod();
void UpdateLeft();
void UpdateRight();
void UpdateBinaryCounter();

void UpdateSteeringControlStraight();

//void PrintStatus();

//State Methods
void TriggerSwitch();
void StopMethod();
void WaitMethod();
void RunMethod();

int main() {
    cout << "\rCarStart" << endl;
    Init();
    while(1) {Loop();}
    //int r = counter; for(int b = 3; b <= 0; b--){ if(r > pow(2,b+1)){ LED[b] = LEDON; r = r - pow(2,b+1);}           
}

void Init() //Initializer
{
    bt.baud(BLUETOOTHBAUDRATE);
    _MotorControl.period(FPWM);
    SetMotor(0.0f); //Turns off the motor
    _error = 0.0f;
    _errorArea = 0.0f;
    _ref = 0.0f;
    _steeringControllerOut = 0.0f;
    _dutyCycle= 0.0f;
    _steeringArea= 0.0f;
    _NextState = EMPTY;
    _CurrentState = EMPTY;
    StopMethod();
    TriggerSwitch();
    _feedbackPrev = 0.0f;
    _servo.period(0.02);
   // _RunButton.rise(&TriggerSwitch);
   // _StopButton.rise(&StopMethod);
    //_BumperStop.rise(&BumperStopMethod);
    arrowheadLeft.rise(&UpdateLeft);
    arrowheadRight.rise(&UpdateRight);
    BreaksOn();
    _ArrowHitRight = false;
    _ArrowHitLeft = false;
    Update.attach(&UpdateDriveControl, TI);
    //Update.attach(&UpdateMethod, TI);
    sUpdate.attach(&UpdateSteeringControl, TI);
    loopUpdate.attach(&UpdateLoop, 0.75f
    );
    //SetMotor(_ref);
}

void Loop() //Repeated Loop
{
    /*wait(.75);
    
    if(_StopButton.read()>=.9)
        StopMethod();
    if(_RunButton.read()>=.9)
        TriggerSwitch();
    
    _ArrowHitRight = false;
    _ArrowHitLeft = false;
    UpdateLowBatteryStop();
    led_blue = !led_blue;
    //PrintStatus();
    //bt.printf("\rGroup 2: USC Football team\n Josh: %f      \033[F",_LeftSensors.read() - _RightSensors.read());
    //_counter++;
    //if(_counter == 11) _counter = 0; 
    //UpdateBinaryCounter();
    cout<< "\r"<<_SecondBinaryLED.read() << endl;
    //cout<< "\r"<<_controllerOutput << endl;*/
}

void UpdateLoop() //
{
    if(_StopButton.read()>=.9)
        StopMethod();
    if(_RunButton.read()>=.9)
        TriggerSwitch();
    if(_BumperStop.read()<=.3)
        StopMethod();
    _ArrowHitRight = false;
    _ArrowHitLeft = false;
    UpdateLowBatteryStop();
    led_blue = !led_blue;
    UpdateLowBatteryStop();
    bt.printf("\rGroup 2: USC Football team\n Josh: %f      \033[F",_LeftSensors.read() - _RightSensors.read());
} 
void UpdateMethod() //
{
    UpdateDriveControl();
    UpdateSteeringControl();
    //UpdateLowBatteryStop();
} 
    
void UpdateDriveControl()
{
    if(_CurrentState == RUN)
    {
    _ref = 0.6; //_SpeedReference.read();
    _error = _ref - _Tacho.read();
    _errorArea += TI*_error;
    _controllerOutput = dKP*_error+ dKI*_errorArea;
    }
    SetMotor(_controllerOutput);
   
}

void UpdateSteeringControl(void)
{
    if(_CurrentState != STOP){
    float feedback = _LeftSensors.read() - _RightSensors.read();
    float reference = 0.075f;
    float err = reference - feedback;
    float feedbackChange = (feedback - _feedbackPrev)/TI;
    _steeringArea += TI*err;
    _steeringControllerOut = sKP*err + sKD*feedbackChange + sKI*_steeringArea;
    float controllerOutNorm = (_steeringControllerOut + M_PI/2.0f)/M_PI;
    _dutyCycle = DCSLOPE*controllerOutNorm + DCINTERCEPT;
    
    /*if(_dutyCycle >= .085)
        _dutyCycle = .085;
    if(_dutyCycle <= .065)
        _dutyCycle = .065;*/
    if (abs(_dutyCycle-_servo.read()) > TOL)
        _servo.write(_dutyCycle);
        
    _feedbackPrev = feedback;
    
    if (_LeftSensors.read() < .4091 && _RightSensors.read() < .40152){
        StopMethod();
        //_CurrentState = STOP;
        //BreaksOn();
        //led_red =0.25f;
        //led_blue =0.25f;
        //led_green =0.25f;
        //_NextState = WAIT;
        }
    }
    
}



void UpdateLowBatteryStop()
{
    float val = 0.5;       // variable for the A/D value
    float pinVoltage = 0; // variable to hold the calculated voltage
    float batteryVoltage = 0; 
    val = _BattMon.read();    // read the voltage on the divider  
  
    pinVoltage = val * 0.30303;       //  Calculate the voltage on the A/D pin
                                    //  A reading of 1 for the A/D = 0.0048mV
                                    //  if we multiply the A/D reading by 0.00488 then 
                                    //  we get the voltage on the pin.                                  
                                    
    batteryVoltage = pinVoltage * RATIO;    //  Use the ratio calculated for the voltage divider
                                          //  to calculate the battery voltage
    if(batteryVoltage < 1.00){
      cout << "\n\rBattery Voltage is too low. Stop Method " << endl;
      StopMethod();
      } else{
          cout << "\n\rBattery Voltage is: " << batteryVoltage << endl;
          }
  
    //wait(1000);                 //  Slow it down    
}

void SetMotor(float speed)
{
    float invD = 0.0f;
    if(speed<0.0f)
    invD =0.0f;
    else if(speed> 0.9f)
    invD = 0.9f;
    else
    invD = speed;   
 
    _MotorControl.write(/*1.0f-*/invD);
}

void BreaksOn()
{
    _controllerOutput = 0;
    _errorArea = 0;
    _steeringArea = 0.0;
    _BreakSignal = 1;
    _servo=0.1f;
}

void BreaksOff()
{
    _controllerOutput = 0;
    _steeringArea = 0.0;
    _errorArea = 0;
    _BreakSignal = 0;
}

void WaitMethod()
{
    _CurrentState = WAIT;
    BreaksOff();
    led_red =.125;
    led_blue =1;
    led_green =.125;
    _NextState = RUN;
}

void RunMethod()
{
    _CurrentState = RUN;
    BreaksOff();
    led_red =1;
    led_blue =1;
    led_green =0.25;
    _NextState = WAIT;
}

void StopMethod()
{   
    _CurrentState = STOP;
    BreaksOn();
    led_red =0.25;
    led_blue =1;
    led_green =1;
    _NextState = WAIT;
}

void BumperStopMethod()
{   
    _CurrentState = STOP;
    BreaksOn();
    led_red =0.25;
    led_blue =1;
    led_green =1;
    _NextState = WAIT;
}

void LowBatteryStopMethod()
{
    _CurrentState = STOP;
    BreaksOn();
    led_red=0.25;
    led_blue=1;
    led_green=1;
    _NextState = WAIT;
}

void TriggerSwitch()
{
    switch(_NextState){
    case STOP:
    StopMethod();
    break;
    
    case  WAIT:
    WaitMethod();
    break;
    
    case RUN:
    RunMethod();
    break;
    
    case EMPTY:
    led_red =0.25;
    led_blue =0.25;
    led_green =0.25;
    _NextState = WAIT;
    break;
    }
}
     
void UpdateLeft(void)
{
 
    if(_counter >=10) {
        _counter = 0;
    } else {
        _counter += 1;
    }
    if(_ArrowHitRight)
    {_counter = 0;_ArrowHitRight=!_ArrowHitRight;
    _steeringArea =0;}
    cout << "\n\rcounter =  " << _counter << endl;
    cout << "\n\rLEFT" << endl;
    UpdateBinaryCounter();
    _ArrowHitLeft = true;
    //if(led_blue == 1.0f)led_blue = 0.0f;
    //else led_blue = 1.0f;
}
    
void UpdateRight(void)
{
 
    if(_counter >=10) {
        _counter = 0;
    } else {
        _counter += 1;
    }
    if(_ArrowHitLeft)
    {_counter = 0;_ArrowHitLeft=!_ArrowHitLeft;
    _steeringArea = 0;}
    cout << "\n\rcounter =  " << _counter << endl;
    cout << "\n\rRIGHT" << endl;
    UpdateBinaryCounter();
    _ArrowHitRight = true;
    //if(led_blue == 1.0f)led_blue = 0.0f;
    //else led_blue = 1.0f;
}

void UpdateBinaryCounter()
{
    switch(_counter){
        case 0:
            _FirstBinaryLED = LEDOFF;
            _SecondBinaryLED = LEDOFF;
            _ThirdBinaryLED = LEDOFF;
            _FourthBinaryLED = LEDOFF;
        break;
        case 1:
            _FirstBinaryLED = LEDON;
            _SecondBinaryLED = LEDOFF;
            _ThirdBinaryLED = LEDOFF;
            _FourthBinaryLED = LEDOFF;
        break; 
        case 2:
            _FirstBinaryLED = LEDOFF;
            _SecondBinaryLED = LEDON;
            _ThirdBinaryLED = LEDOFF;
            _FourthBinaryLED = LEDOFF;
        break;
        case 3:
            _FirstBinaryLED = LEDON;
            _SecondBinaryLED = LEDON;
            _ThirdBinaryLED = LEDOFF;
            _FourthBinaryLED = LEDOFF;
        break;    
        case 4:
            _FirstBinaryLED = LEDOFF;
            _SecondBinaryLED = LEDOFF;
            _ThirdBinaryLED = LEDON;
            _FourthBinaryLED = LEDOFF;
        break;
        case 5:
            _FirstBinaryLED = LEDON;
            _SecondBinaryLED = LEDOFF;
            _ThirdBinaryLED = LEDON;
            _FourthBinaryLED = LEDOFF;
        break;    
        case 6:
            _FirstBinaryLED = LEDOFF;
            _SecondBinaryLED = LEDON;
            _ThirdBinaryLED = LEDON;
            _FourthBinaryLED = LEDOFF;
        break;
        case 7:
            _FirstBinaryLED = LEDON;
            _SecondBinaryLED = LEDON;
            _ThirdBinaryLED = LEDON;
            _FourthBinaryLED = LEDOFF;
        break;
        case 8:
            _FirstBinaryLED = LEDOFF;
            _SecondBinaryLED = LEDOFF;
            _ThirdBinaryLED = LEDOFF;
            _FourthBinaryLED = LEDON;
        break;
        case 9:
            _FirstBinaryLED = LEDON;
            _SecondBinaryLED = LEDOFF;
            _ThirdBinaryLED = LEDOFF;
            _FourthBinaryLED = LEDON;
        break;
        case 10:
            _FirstBinaryLED = LEDOFF;
            _SecondBinaryLED = LEDON;
            _ThirdBinaryLED = LEDOFF;
            _FourthBinaryLED = LEDON;
        break;
        default:
            _FirstBinaryLED = LEDOFF;
            _SecondBinaryLED = LEDOFF;
            _ThirdBinaryLED = LEDOFF;
            _FourthBinaryLED = LEDOFF;
        break;               
    } 
}
/*
void PrintStatus()
{
    if(bt.readable()) {
        char input = bt.getc();
        if(input == 'i')_CurrentState = RUN;
        if(input == 'o')_CurrentState = WAIT;
        if(input == 'p')_CurrentState = STOP;
        if(input == 'q')sKP+=.005;
        if(input == 'a')sKP-=.005;
        if(input == 'w')sKD+=.0001;
        if(input == 's')sKD-=.0001;
        if(input == 'e')sKI+=.001;
        if(input == 'd')sKI-=.001;
        if(input == 'r')_counter+=1;
        if(input == 'f')_counter-=1;
        
    }      
    bt.printf("\033[20F");    
    bt.printf("\r\n KP : %f",sKP);
    bt.printf("\r\n KD : %f",sKD);
    bt.printf("\r\n KI : %f",sKI);
    bt.printf("\r\n location : %d", _counter);
    bt.printf("\r\n Duty Cycle : %f", _dutyCycle);
    
}*/