#include "mbed.h"
#include "neopixel.h"
#include "mp3.hpp"
#include "scrp_slave.hpp"

Serial pc(USBTX,USBRX);
ScrpSlave slave(PC_12,PD_2,PH_1,SERIAL_TX,SERIAL_RX,5);
NeoPixelOut npx(PB_0,16);
Playmp3 mp3(PA_0,PA_1);
bool areamode = 0;
bool colormode = 0;
bool stop = 0;
bool start = 0;

int i = 0;

//農作物回収　1
bool play1(int rx_data,int &tx_data)
{
    if(rx_data == 1) {
        mp3.set_number_of_tracks(1);
    }
    return true;
}

//農作物設置　2
bool play2(int rx_data,int &tx_data)
{
    if(rx_data == 1) {
        mp3.set_number_of_tracks(2);
    }
    return true;
}

//ビーンバック回収　3
bool play3(int rx_data,int &tx_data)
{
    if(rx_data == 1) {
        mp3.set_number_of_tracks(3);
    }
    return true;
}

//自動運転モードに移行　４
bool play4(int rx_data,int &tx_data)
{
    if(rx_data == 1) {
        mp3.set_number_of_tracks(4);
    }
    return true;
}

//ビーンバック発射　５
bool play5(int rx_data,int &tx_data)
{
    if(rx_data == 1) {
        mp3.set_number_of_tracks(5);
    }
    return true;
}

//スタート　6
bool get_start(int rx_data,int &tx_data)
{
    if(rx_data == 0) {
        if(start == 1) {
            start = 0;
        }
    } else {
        if(start == 0) {
            start = 1;
        }
    }
    return true;
}

//モード変更　50
bool get_changemode(int rx_data,int &tx_data)
{
    if(rx_data == 0) {
        if(colormode == 1) {
            colormode = 0;
        }
    } else {
        if(colormode == 0) {
            colormode = 1;
        }
    }
    return true;
}

//非常停止　51
bool get_stop(int rx_data,int &tx_data)
{
    if(rx_data == 0) {
        stop = 0;
    } else {
        stop = 1;
        for(i=0; i<npx.numPixels(); i++) {
            npx.setPixelColor(i,0x000000);
        }
    }
    return true;
}

//エリアチェンジ　52
bool get_areachange(int rx_data,int &tx_data)
{
    if(rx_data == 0) {
        if(areamode == 1) {
            areamode = 0;
        }
    } else {
        if(areamode == 0) {
            areamode = 1;
        }
    }
    return true;
}

int main()
{
    //農作物回収
    slave.addCMD(1,play1);
    //農作物設置
    slave.addCMD(2,play2);
    //ビーンバック回収
    slave.addCMD(3,play3);
    //自動運転モードに移行
    slave.addCMD(4,play4);
    //ビーンバック発射
    slave.addCMD(5,play5);
    //スタート
    slave.addCMD(6,get_start);
    //モード変更
    slave.addCMD(50,get_changemode);
    //非常停止
    slave.addCMD(51,get_stop);
    //エリア変更
    slave.addCMD(52,get_areachange);
    //光の強さ
    npx.global_scale = 0.05f;
    //信号来ていないときは光らない
    npx.normalize = false;
    //音量セット
    mp3.set_volume(255);
    //クワイエットモードOFF
    mp3.quiet_mode(false);

    while(1) {
        //非常停止解除
        if(stop == 0) {
            if(start == 0) {
                //フィールド赤
                if(areamode == 0) {
                    for(i = 0; i < npx.numPixels(); i++) {
                        npx.setPixelColor(i,0xFF0000);
                        npx.show();
                        wait(0.05);
                    }
                    pc.printf("red area\n");
                    //フィールド青
                } else if(areamode == 1) {
                    for(i = 0; i < npx.numPixels(); i++) {
                        npx.setPixelColor(i,0x0000FF);
                        npx.show();
                        wait(0.05);
                    }
                    pc.printf("bule area\n");
                }
            } else {
                //手動モード　黄色
                if(colormode == 0) {
                    for(i = 0; i < npx.numPixels(); i++) {
                        npx.setPixelColor(i,0xFFF100);
                        npx.show();
                        wait(0.05);
                        if(i == npx.numPixels()) {
                            i = 0;
                        }
                    }
                    pc.printf("control\n");
                    //自動モード　緑
                } else if(colormode == 1) {
                    for(i = 0; i < npx.numPixels(); i++) {
                        npx.setPixelColor(i,0x00FF00);
                        npx.show();
                        wait(0.05);
                        if(i == npx.numPixels()) {
                            i = 0;
                        }
                    }
                    pc.printf("auto\n");
                }
            }
            //非常停止
        } else if(stop == 1) {
            for(i = 0; i < npx.numPixels(); i++) {
                npx.setPixelColor(i,0x000000);
                npx.show();
                wait(0.05);
                if(i == npx.numPixels()) {
                    i = 0;
                }
            }
            pc.printf("stopping\n");
        }
    }
}