//-----Libraries-----
#include "mbed.h"
#include "scrp_slave.hpp"
#include "motor.hpp"

//-----Classes-----
ScrpSlave slave(PA_9, PA_10, PA_12, SERIAL_TX, SERIAL_RX, 4);   //id: 4
Motor motor1(PA_11, PB_6);//左
Motor motor2(PA_3, PA_1);//右
DigitalIn Limitswitch1(PA_0);
DigitalIn Limitswitch2(PA_4);
DigitalIn Limitswitch3(PB_0);
DigitalIn Limitswitch4(PB_1);

//-----Constants-----
const double pwm = 0.4;

//-----Sub Routines-----
bool Up(int RX,int &TX);
bool Down(int RX,int &TX);

//-----Variables-----
int up = 0;
int down = 0;
double PWM1 = 0.0;
double PWM2 = 0.0;
int limitswitch1 = 1;
int limitswitch2 = 1;
int limitswitch3 = 1;
int limitswitch4 = 1;

//-----Main Routine-----
int main(){
    slave.addCMD(1, Up);
    slave.addCMD(2, Down);
    Limitswitch1.mode(PullUp);
    Limitswitch2.mode(PullUp);
    Limitswitch3.mode(PullUp);
    Limitswitch4.mode(PullUp);
    while(1){
        limitswitch1 = Limitswitch1.read() ? 0 : 1;
        limitswitch2 = Limitswitch2.read() ? 0 : 1;
        limitswitch3 = Limitswitch3.read() ? 0 : 1;
        limitswitch4 = Limitswitch4.read() ? 0 : 1; 
        printf("%d %d %d %d %d %d\n", up, down, limitswitch1, limitswitch2, limitswitch3, limitswitch4);
        PWM1 = pwm * ((up * limitswitch1) - (down * limitswitch3));
        PWM2 = pwm * ((up * limitswitch2) - (down * limitswitch4)) * 0.8;
        motor1.out(PWM1);
        motor2.out(PWM2);
    }
}

bool Up(int RX, int &TX){
    if(RX == 1)up = RX;
    return true;
}

bool Down(int RX, int &TX){
    down = RX;
    if(RX == 1)up = 0;
    return true;
}