#ifndef PID_CONTROL_H
#define PID_CONTROL_H
#include "mbed.h"
#define co (108*3.1415926535897)/500

class PIDcontrol{
    public:
        double spd;//速度
        double error_n,error_b;//現在の誤差、過去の誤差
        double P,I,D;//pid制御のそれぞれの値
        double pwm,v1p_set,v1m_set;//モータに入れる値
        double integral;//誤差の面積
        double finish,pulse,pal;//パルス関係
        double target;//目標値
        PIDcontrol();//コンストラクタ
        void motor_control(double var_1,double var_2,PinName pin_a,PinName pin_b);//pwmをreturnする関数
        double get_spd();//spdをreturnする関数
    private:
        void speed();//spd計算
        void control();//PID制御
        double dt;//dt=0.05
        double Kp,Ki,Kd;//PID制御
};

#endif

        
        