#include "mbed.h"
#include "neopixel.h"
#include "mp3.hpp"
#include "rotary_inc.hpp"
#include "scrp_slave.hpp"

Serial pc(USBTX,USBRX);
ScrpSlave slave(PC_12,PD_2,PH_1,SERIAL_TX,SERIAL_RX,5);
RotaryInc rotaryx(PA_7,PA_6,30 * M_PI,512);
RotaryInc rotaryy(PC_4,PA_13,30 * M_PI,512);
PwmOut motor1[2] = {
    PwmOut(PB_7),
    PwmOut(PB_9)
};
PwmOut motor2[2] = {
    PwmOut(PB_6),
    PwmOut(PB_8)
};
NeoPixelOut npx(PB_0,16);
Playmp3 mp3(PA_0,PA_1);
bool colormode = 0;
bool stop = 0;
bool up = 1;
bool down = 0;
bool front = 0;
bool back = 0;
bool slope = 0;
bool move = 0;
int num = 0;
int i = 0;

//ボイス　2
bool play1(int rx_data,int &tx_data)
{
    //農作物回収　1
    if(rx_data == 1) {
        mp3.set_number_of_tracks(1);
    }
    //農作物設置　2
    else if(rx_data == 2) {
        mp3.set_number_of_tracks(2);
    }
    //ビーンバック回収　3
    else if(rx_data == 3) {
        mp3.set_number_of_tracks(3);
    }
    //自動運転モードに移行　４
    else if(rx_data == 4) {
        mp3.set_number_of_tracks(4);
    }
    //ビーンバック発射　５
    else if(rx_data == 5) {
        mp3.set_number_of_tracks(5);
    } else {}
    return true;
}

//モード変更　50
bool get_changemode(int rx_data,int &tx_data)
{
    if(rx_data == 0) {
        if(colormode == 1) {
            colormode = 0;
        }
    } else {
        if(colormode == 0) {
            colormode = 1;
        }
    }
    return true;
}

//非常停止　51
bool get_stop(int rx_data,int &tx_data)
{
    if(rx_data == 0) {
        stop = 0;
    } else {
        stop = 1;
        for(i=0; i<npx.numPixels(); i++) {
            npx.setPixelColor(i,0x000000);
        }
    }
    return true;
}

//ビーンバック回収 1
bool getting(int rx_data,int &tx_data)
{
    if(rx_data == 0) {
        if(move == 1) {
            move = 0;
        }
    } else {
        if(move == 0) {
            move = 1;
            num++;
        }
    }
    return true;
}

int main()
{
    //ビーンバック回収
    slave.addCMD(1,getting);
    //ボイス
    slave.addCMD(2,play1);
    //モード変更
    slave.addCMD(50,get_changemode);
    //非常停止
    slave.addCMD(51,get_stop);
    //光の強さ
    npx.global_scale = 0.05f;
    //信号来ていないときは光らない
    npx.normalize = false;
    //音量セット
    mp3.set_volume(255);
    //クワイエットモードOFF
    mp3.quiet_mode(false);

    while(1) {
        //非常停止解除
        if(stop == 0) {
            double distance = rotaryx.get();
            double height = rotaryy.get();
            pc.printf("num %d move %d\n",num,move);
            //pc.printf("distance %lf  height %lf up %d down %d front %d back %d\n",distance,height,up,down,front,back);
            wait(0.01);
            //手動モード　黄色
            if(colormode == 0) {
                for(i = 0; i < npx.numPixels(); i++) {
                    npx.setPixelColor(i,0xFFF100);
                    npx.show();
                    wait(0.01);
                    if(i == npx.numPixels()) {
                        i = 0;
                    }
                }
                pc.printf("control\n");
                //自動モード　緑
            } else if(colormode == 1) {
                for(i = 0; i < npx.numPixels(); i++) {
                    npx.setPixelColor(i,0x00FF00);
                    npx.show();
                    wait(0.01);
                    if(i == npx.numPixels()) {
                        i = 0;
                    }
                }
                pc.printf("auto\n");
            }
            if(num == 0) {}
            else {
                switch(num%2) {
                    case 1:
                        if(distance >= -300 && up == 1) {
                            motor1[0] = 0.35;
                            motor2[0] = 0;
                            motor1[1] = 0;
                            motor2[1] = 0;
                        }

                        if(distance <= -300 && up == 1) {
                            up = 0;
                            down = 0;
                            front = 1;
                            back = 0;
                            slope = 0;
                        }

                        if(front == 1 && height >= -127) {
                            motor1[0] = 0;
                            motor2[0] = 0;
                            motor1[1] = 0.2;
                            motor2[1] = 0;
                        }

                        if(height <= -127 && front == 1) {
                            up = 0;
                            down = 1;
                            front = 0;
                            back = 0;
                            slope = 0;
                        }

                        if(distance  <= -300 && height <= -127) {
                            motor1[0] = 0;
                            motor2[0] = 0;
                            motor1[1] = 0;
                            motor2[1] = 0;
                        }
                        break;

                    case 0:
                        if(distance <= -90 && down == 1) {
                            motor1[0] = 0;
                            motor2[0] = 0.35;
                            motor1[1] = 0;
                            motor2[1] = 0;
                        }

                        if(distance >= -90 && down == 1) {
                            up = 0;
                            down = 0;
                            front = 0;
                            back = 1;
                            slope = 0;
                        }

                        if(distance <= 0 && back == 1) {
                            motor1[0] = 0;
                            motor2[0] = 0.2;
                            motor1[1] = 0;
                            motor2[1] = 0.2;
                        }

                        if(distance >= 0 && back == 1) {
                            up = 0;
                            down = 0;
                            front = 0;
                            back = 0;
                            slope = 1;
                        }

                        if(slope == 1 && height <= 1) {
                            motor1[0] = 0;
                            motor2[0] = 0;
                            motor1[1] = 0;
                            motor2[1] = 0.2;
                        }

                        if(height >= 1 && slope == 1) {
                            up = 1;
                            down = 0;
                            front = 0;
                            back = 0;
                            slope = 0;
                        }

                        if(distance >= 1 && height >= 1) {
                            motor1[0] = 0;
                            motor2[0] = 0;
                            motor1[1] = 0;
                            motor2[1] = 0;
                        }
                        break;
                    default:
                        break;
                }
            }    
        //非常停止
        } else if(stop == 1) {
            for(i = 0; i < npx.numPixels(); i++) {
                npx.setPixelColor(i,0x000000);
                npx.show();
                wait(0.01);
                if(i == npx.numPixels()) {
                    i = 0;
                }
            }
            pc.printf("stopping\n");
        }
    }
}