#include "mbed.h"

DigitalOut cam_sw1(D10);      //カメラの電源スイッチに接続（Highで電源ON）
DigitalOut cam_sw2(D9);      //カメラの撮影スイッチ(FET)に接続(HighでD-S導通)
//DigitalIn IM920(D12);        //地上局からの無線(撮影開始タイミング操作用)

Serial pc(USBTX, USBRX);


int main()
{
    pc.printf("Program Start\r\n");
    

    while(1) {

        cam_sw1 = 0;//電源スイッチOFF状態
        cam_sw2 = 0;//撮影スイッチOFF状態
        
        int received_data = pc.getc();

            if(received_data == 83 || received_data == 115) { //Sかs（電源ON指示）が入力された時
                break;
            }

    }

    cam_sw1 = 1;             //カメラの電源スイッチON
    wait(3);
    cam_sw1 = 0;
    wait(10);                //カメラの電源ON

    while(1) {

        int received_data = pc.getc();
        
            if(received_data == 84 || received_data == 116) { //Tかt（撮影開始指示）が入力された時
                break;
            }
    }

    cam_sw2 = 1;             //撮影スイッチON(撮影開始指示)
    wait(0.2);               //撮影開始
    cam_sw2=0;
    
    while(1) {
        
        int received_data = pc.getc();

            if(received_data == 83 || received_data == 115) { //Sかs（撮影終了指示）が入力された時
                break;
            }

    }
    
    cam_sw2=1;               //撮影スイッチON(撮影終了指示)
    wait(0.2);               //撮影終了
    cam_sw2=0;

}