/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "SDFileSystem.h"
//#include "platform/mbed_thread.h"

Serial jy901(D1,D0);
Serial pc(USBTX,USBRX);
SDFileSystem sd(PA_7, PA_6, PA_5, PA_4, "sd"); // the pinout on the mbed Cool Components workshop board

// Blinking rate in milliseconds
int main()
{
    jy901.baud(9600);
    printf("Hello World!\n"); 
 
    mkdir("/sd/mydir2", 0777);   
    FILE *fp = fopen("/sd/mydir2/sdtest.bin", "w");
    
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    
    while(1){    
        fputc(jy901.getc(),fp);
    }
    fclose(fp);   
}
