/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

/*センサーにコマンドを送信するのはとりあえず後回し
GPSのデータを受信するのも後回し*/

#include "mbed.h"
#include "SDFileSystem.h"
#include "BufferedSerial.h"

BufferedSerial jy901(PA_9,PA_10);
//BufferedSerial jy901(PA_9,PA_10);
SDFileSystem sd(PA_7, PA_6, PA_5, PA_4, "sd");  //mosi, miso, sck, cs
//BufferedSerial f303(PA_2,PA_3,38400);
//Serial f303(PA_2,PA_3,38400);
DigitalIn F2L_1(PA_3);
DigitalIn F2L_2(PA_2);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
//Serial pc(USBTX, USBRX,38400);//ボーレートを落とすと，USB側からのデータが正確に出力されない.

int sig=0;
FILE *fp;
Ticker comm_1;
Ticker comm_2;
Ticker comm_3;

char str[10];
char NichromeCom[11]={0x55,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
//Timeout FlightPin;
Timeout fileClose;

int getSignal();    //f303からのコマンドを受け取る関数
//void JY901();   //JY901が取得した生データをSDに書き込む関数
void getGPS();  //GPSデータを取得し、f303に送信する関数

void StandbyPin();
void StandbyCommand();
void StandbyNichrome();
void StandbyBuzzer();
void MakeFile();
void writeNichrome();
void close();

int main()
{
    unsigned char CalibGyroAcc[5]={0xFF,0xAA,0x01,0x01,0x00};
    unsigned char CalibMag[5]={0xFF,0xAA,0x01,0x02,0x00};
    unsigned char SetHeight[5]={0xFF,0xAA,0x01,0x03,0x00};
    unsigned char ExitCalib[5]={0xFF,0xAA,0x01,0x00,0x00};
    comm_1.attach(StandbyPin,0.1);    //割り込みで1秒ごとにf303からのコマンドを取得

    /**********************
    //センサーのsleepモードを終わらせて、キャリブレーションを開始する関数
    *****************/
        
    jy901.write(CalibGyroAcc,5);
    wait(45);
    jy901.write(CalibMag,5);
    wait(30);
    jy901.write(SetHeight,5);
    wait(30);
    jy901.write(ExitCalib,5);   //キャリブレーションモード終了
    
    while(sig==4) {
        fputc(jy901.getc(),fp);
    }   
}

void StandbyPin()
{
    //printf("StandbyCommand start\r\n");
    if(F2L_1 == 1 && F2L_2 == 0){
        sig=4;
        comm_1.detach();
        
        led2=1; //2回点滅
        wait(0.1);
        led2=0;
        wait(0.1);
        led2=1;
        wait(0.1);
        led2=0;
        
        MakeFile();
        printf("FlightPin\r\n");
        comm_2.attach(StandbyNichrome,0.4);
    }
}

void StandbyNichrome(){
    if(F2L_1 == 1 && F2L_2 == 1){
        comm_2.detach();
        fwrite(&NichromeCom,sizeof(NichromeCom[0]),sizeof(NichromeCom),fp);
        
        led2=1; //1回点滅
        wait(0.1);
        led2=0;
        
        printf("1\r\n");
        fileClose.attach(close,70);
        printf("Nichrome start\r\n");   
        comm_3.attach(StandbyBuzzer,1);
    }
}

void StandbyBuzzer(){
    if(F2L_1 == 0 && F2L_2 == 1){
        comm_3.detach();
        
        led2=1; //3回点滅
        wait(0.1);
        led2=0;
        wait(0.1);
        led2=1;
        wait(0.1);
        led2=0;
        wait(0.1);
        led2=1;
        wait(0.1);
        led2=0;
        printf("3\r\n");
        
        close();
        
        while(1) {
            getGPS();
        }
    }   
}

void MakeFile(){
    mkdir("/sd/2021MR", 0777);
    FILE *fp = fopen("/sd/2021MR/chigusa.bin", "wb");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
}

void getGPS(){
    char buf[10000],data[10000];
    int ucRxCnt,j=0;
    //string GPSStatus="";
    /*FILE *fp = fopen("/sd/2021MR/ground.bin", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }*/

    for(int i=0; i<10000; i++) {
        buf[i]=jy901.getc();
    }

    while(j<=int(sizeof(buf)/sizeof(buf[0]))) {
        data[ucRxCnt++]=buf[j];  //Store the received data in the buffer
        if (data[0]!=0x55) { //The data header is not correct, then restart to find the 0x55 data header
            ucRxCnt=0;
            // printf("not start sig\n");
        } else if(ucRxCnt<11) {
            //printf("data is less than 11\n\r");
        }//If the data is less than 11, alert.
        else {
            //printf("switch\n\r");
            switch(data[1]) { //Determine what kind of data the data is, and then copy it to the corresponding structure. Some data packets need to open the corresponding output through the upper computer before receiving the data of this data packet.
                /* case 0x50:    memcpy(&stcTime,&ucRxBuffer[2],8);break;//memcpy is a memory copy function that comes with the compiler. You need to reference "string.h" to copy the characters of the receive buffer into the data structure to achieve data parsing.
                 case 0x51:
                     printf("case 0x51 worked!");
                     memcpy(&stcAcc,&data[2],8);
                     fprintf(facc,"Acc,%.3f,%.3f,%.3f\r\n",(float)stcAcc.a[0]/32768*16,(float)stcAcc.a[1]/32768*16,(float)stcAcc.a[2]/32768*16);
                     break;
                 case 0x52:  memcpy(&stcGyro,&ucRxBuffer[2],8);break;
                 case 0x53:  memcpy(&stcAngle,&ucRxBuffer[2],8);break;
                 case 0x54:  memcpy(&stcMag,&ucRxBuffer[2],8);break;
                 case 0x55:  memcpy(&stcDStatus,&ucRxBuffer[2],8);break;
                 case 0x56:  memcpy(&stcPress,&ucRxBuffer[2],8);break;
                 case 0x57:  memcpy(&stcLonLat,&ucRxBuffer[2],8);break;*/
                case 0x58:
                    //memcpy(&stcGPSV,&data[2],8);
                    //sprintf(GPSStatus,"GPSHeight:%.1fm GPSYaw:%.1fDeg GPSV:%.3fkm/h\r\n",(float)stcGPSV.sGPSHeight/10,(float)stcGPSV.sGPSYaw/10,(float)stcGPSV.lGPSVelocity/1000);
                    //f303.printf("%s",GPSStatus);
                    //printf("come a GPS data!!");
                    break;
                    //case 0x59:  memcpy(&stcQ,&ucRxBuffer[2],8);break;
            }
            ucRxCnt=0;//Clear the cache area
        }
        j++;
    }
}

void close(){
    printf("finished\r\n");
    fclose(fp);
}