#include "mbed.h"
//#include "BufferedSerial.h"

//コマンド取得とモード変換は関数にいれたほうがわかりやすい
void nichrome_ON();
void buzzerON();
int getCommand();
void sendStatus();
void FlightPinDriver();

Serial pc(USBTX, USBRX,38400);//ボーレートを落とすと，USB側からのデータが正確に出力されない.
//BufferedSerial im920(PA_9,PA_10,19200);//TX(IM920_RX), RX(IM920_TX)
Serial im920(PA_9,PA_10,19200);//TX(IM920_RX), RX(IM920_TX)
//DigitalOut mcu_1(PA_7);
//DigitalOut mcu_2(PA_6);
//BufferedSerial L432(PA_2,PA_3,38400);

//Serial L432(PA_2,PA_3,38400);
DigitalOut F2L_1(PA_2);
DigitalOut F2L_2(PA_3);

DigitalOut cameraPow(PA_11);
DigitalOut cameraRec(PA_8);
DigitalOut nichrome(PF_0);
DigitalOut buzzer(PF_1);
DigitalIn flightPin(PA_12);
Timeout t;
Ticker sta;
Ticker warikomi;
char str[100];
char comm[25];
//int i=0;
int flag; //flag：現在の状態
//0：開始時、１：スリープ解除あるいはスリープに入った、2：撮影開始、(3：撮影終了、使わない)9：リセット


int main()
{
    //ここに電源投入のプロトコル

    /******以下3行は開始時のカメラの状態がわからないため、開始と同時に強制スリープにする。他にいい方法ねーかな******/
    wait(5);

    cameraPow = 1;   //カメラの電源スイッチON
    wait(3);
    cameraPow = 0;
    sta.attach(sendStatus,5);
    warikomi.attach(FlightPinDriver,0.5);

    //while(flightPin!=1){    //フライトピンが作動していない場合
    flag=0;
    F2L_1 = 0;
    F2L_2 = 0;    //マイコン間通信のピンはどちらも0
    pc.printf("stable\r\n");
    while(1) {
        //FlightPinDriver();
        
        /*if(flightPin==0){
               break;
        }*/
        flag=getCommand();
        switch(flag) {
            case 0:
                break;
            case 1:
                //printf("Camera is awake\r\n");
                break;
            case 2:
                //printf("Video start\r\n");
                break;
            case 9:
                flag=0;
                //printf("Stop command!\r\n");
                /******以下3行は開始時のカメラの状態がわからないため、開始と同時に強制スリープにする。他にいい方法ねーかな*****/
                cameraPow = 1;   //カメラの電源スイッチON
                wait(3);
                cameraPow = 0;
                break;
        }
    }
    
}

void nichrome_ON()
{
    //printf("テグスカット!\n\r");
    F2L_1 = 1;
    F2L_2 = 1;     //マイコン間通信のピンはどちらも1
    nichrome=1;
    wait(5.0);//テグスを切るまでにかかる時間
    nichrome=0;
    t.detach();
    t.attach(buzzerON,60);//ブザー作動までの時間
}

void buzzerON()
{
    pc.printf("buzzer ON\n\r");
    //L432.printf("c\r\n"); //センサー停止指示コマンド
    F2L_1 = 0;
    F2L_2 = 1;     //マイコン間通信のピンは2つ目のみ1
    buzzer=1;
    cameraRec=1;//撮影終了指示
    wait(0.2);//この待機時間は要らないのかもしれない
    cameraRec=0;
    wait(1);
    cameraRec=1;               //撮影スイッチON(撮影終了指示)
    wait(0.2);               //撮影終了(撮影中のスリープ？が起きはじめたので2回指示を出すようにした)
    cameraRec=0;
}

int getCommand()
{
    char temp;
    int i=0;
    while(temp != '\n') { //読み込み文字が改行で無い場合(順番では\r\n)
        if(im920.readable()) { //IM920からのデータがある場合
            char temp = im920.getc();//一文字読み込む
            //pc.printf("%c",temp);
            str[i++] = temp;
        } //else if(temp == '\n') { //読み込み文字が改行の場合
        //printf("get Command\r\n");
        if(str[i-2]=='1'&&str[i-1]=='1') { //スリープに入るor抜け出す際にはコマンド"11"
            im920.printf("get 11 !!\r\n");
            cameraPow = 1;             //カメラの電源スイッチON
            wait(3);
            cameraPow = 0;
            //wait(10);                //カメラの電源ON
            return 1;
        } else if(str[i-2]=='2'&&str[i-1]=='2') { //撮影開始の際にはコマンド"22"
            cameraRec = 1;             //撮影スイッチON(撮影開始指示)
            wait(0.2);               //撮影開始
            cameraRec=0;
            im920.printf("get 22\r\n");
            return 2;
        } 
        else if(str[i-2]=='3'&&str[i-1]=='3') { //撮影終了の際にはコマンド"33"
            im920.printf("get 33\r\n");
            //L432.printf("s\r\n"); //L432にセンサ動作開始のコマンド送信
            
            cameraRec=1;               //撮影スイッチON(撮影終了指示)
            wait(0.2);               //撮影終了
            cameraRec=0;
            wait(1);
            cameraRec=1;               //撮影スイッチON(撮影終了指示)
            wait(0.2);               //撮影終了(撮影中のスリープ？が起きはじめたので2回指示を出すようにした)
            cameraRec=0;
            return 3;
        } else if(str[i-2]=='9'&&str[i-1]=='9') { //異常が起きた時に中断するよう
            return 9;
        }
    }
}

void sendStatus()
{
    im920.printf("TXDA 0%d",flag);
    //im920.putc(flag);
    im920.printf("\r\n");
}

void FlightPinDriver()
{
    if(flightPin==1) {
        //L432.putc('p');  //センサー側にフライトピン作動を知らせる→センサー動作開始
        F2L_1 = 1;
        F2L_2 = 0;     //マイコン間通信のピンは1つ目のみ1
    
        im920.printf("flight pin worked\r\n");
        //t.attach(nichrome_ON,3);//ニクロムを作動させるまでの時間
        //ここからGPSの情報取得して送信
        warikomi.detach();
        t.attach(nichrome_ON,2.8);//ニクロムを作動させるまでの時間（本当は4秒だがニクロムが熱をもつまで時間がかかるので2.8秒にしてある）
    }
}