#include "mbed.h"

//コマンド取得とモード変換は関数にいれたほうがわかりやすい
void nichrome_ON();
void buzzerON();
int getCommand();

Serial pc(USBTX, USBRX,38400);//ボーレートを落とすと，USB側からのデータが正確に出力されない.//pcと直接通信してないのに定義する必要ある？
Serial im920(PA_9,PA_10,19200);//TX(IM920_RX), RX(IM920_TX)
DigitalOut mcu_1(PA_7);
DigitalOut mcu_2(PA_6);
DigitalOut cameraPow(PF_0);
DigitalOut cameraRec(PF_1);
DigitalOut nichrome(PA_8);
DigitalOut buzzer(PA_11);
DigitalIn flightPin(PA_12);
Timeout t;
char str[100];   
int i=0;

int main()
{
    //ここに電源投入のプロトコル
    int flag=0;
    while(flightPin==1){
        if(flag==0){
            while(1){
                if(getCommand()==1){
                    flag=1;//flagに1を代入することで先に進む
                    
                    cameraPow=1;
                    wait(3);//3秒間長押しでカメラ起動開始
                    cameraPow=0;
                    wait(7);//カメラ起動待ち時間
                    cameraRec=1;//撮影開始指示
                    wait(0.2);//この待機時間は要らないのかもしれない
                    cameraRec=0;
                    
                    break;
                }
            }
        }
        
        else if(flag==1){
            while(1) {
                if(getCommand()==1){
                    flag=0;//flagに0を代入することで最初に戻る
                    break;
                }
            }
        }
    }
    t.attach(nichrome_ON,3);//ニクロムを作動させるまでの時間
    //ここからGPSの情報取得して送信
}

void nichrome_ON(){
    printf("テグスカット!\n\r");
    nichrome=1;
    wait(2.0);//テグスを切るまでにかかる時間
    nichrome=0;
    t.detach();
    t.attach(buzzerON,6);//ブザー作動までの時間
}

void buzzerON(){
    printf("ブザー作動\n\r");
    buzzer=1;
    
    cameraRec=1;//撮影終了指示
    wait(0.2);//この待機時間は要らないのかもしれない
    cameraRec=0;
    
    //ここからモード変換だけど、わかりにくかったら他の関数に入れてもいいかも
    mcu_1=1;
    wait(0.1);//電流何秒流す?
    mcu_1=0;
}

int getCommand(){
    char temp;
    if(im920.readable()) { //IM920からのデータがある場合
        temp = im920.getc();//一文字読み込む
        if(temp != '\r') { //読み込み文字が改行で無い場合
            str[i] = temp;
            i++;
        } else if(temp == '\r') { //読み込み文字が改行の場合//\nではなく\rを使うのに理由はある？
            if(str[i-2] == 's'&& str[i-1] == 't') { //startの"st"
                  mcu_1=1;
                  wait(0.1);    //電流流すの何秒間にしましょう？
                  mcu_1=0;
                  return 1;
            }
        }
        else if(temp == '\r') { //読み込み文字が改行の場合//\nではなく\rを使うのに理由はある？
                if(str[i-2] == 'r' && str[i-1] == 'e') {
                      mcu_1=1;
                      mcu_2=1;
                      wait(0.1);    //電流流すの何秒間にしましょう？
                      mcu_1=0;
                      mcu_2=0;
                      return 1;
                }
            }
        }    
}