
/**
  ******************************************************************************
  * @file    main.h
  * @author  You
  * @version V?.?.?
  * @date    Today
  * @brief   メインのヘッダファイル
  ******************************************************************************
  */
/* Includes ------------------------------------------------------------------*/
#include <mbed.h>
#include <BNO055.h>
#include <SBDBT.h>
#include <YKNCT_I2C.h>
#include <YKNCT_MD.h>
#include <movement.h>

/* 型定義 --------------------------------------------------------------------*/

/* 座標管理構造体 X,Y,thetaはいずれもdouble型 */
struct ROCATION
{
    double X;
    double Y;
    double theta;
};

/* 定数定義 ------------------------------------------------------------------*/

/* π */
#define PI 3.1415926535

/* Encoderの最大数 */
#define EncoderMAX 2

/* yaw補整の定数 */
#define CONST_CORRECTION_YAW 1

/* X座標移動用加速定数 */
#define CONST_ACC_X 1
/* X座標移動用減速定数 */
#define CONST_DEC_X 1

/* マクロ定義 ----------------------------------------------------------------*/
/* 2つの値を比較して小さい方を返す */
#define M_MIN(__VALUE1__, __VALUE2__) ((__VALUE1__) < (__VALUE2__) ? (__VALUE1__) : (__VALUE2__))

/* 2つの値を比較して大きい方を返す */
#define M_MAX(__VALUE1__, __VALUE2__) ((__VALUE1__) > (__VALUE2__) ? (__VALUE1__) : (__VALUE2__))

/* 絶対値を返す */
#define ABS(__VALUE1__) ((__VALUE1__) < 0 ? -(__VALUE1__) : (__VALUE1__))

/* Enc角度から距離に変換 */
#define DEG_TO_DIS(__DEGREE__) (50.8 * PI * (__DEGREE__) / 360)

/* Enc角度から距離に変換 */
#define DEG_TO_HIGH(__DEGREE__) (50.0 * PI * (__DEGREE__) / 360)

/* Radian,Degree変換 */
/* 定義被ったためコメントアウト */
//#define RAD_TO_DEG(__RADIAN__) (180 * (__RADIAN__) / PI)
//#define DEG_TO_RAD(__DEGREE__) ((__DEGREE__)*PI / 180)

/* lim以上のデータを補整する */
#define Rest(__val__, __Limit__) ((__val__) >= (__Limit__) ? (__Limit__) : ((__val__) <= (-(__Limit__)) ? (-(__Limit__)) : (__val__)))

/* コントローラー SerectとStartを実装 */
#define Select (DS3.LEFTkey+DS3.RIGHTkey==2)
#define Start (DS3.UPkey+DS3.DOWNkey==2)

#define OmuniExe for(int __CNT__;__CNT__<4;__CNT__++) MD.Set(__CNT__,MovMotor[__CNT__]);

/* 関数プロトタイプ宣言 -------------------------------------------------------*/
/* 変数定義 ------------------------------------------------------------------*/
/* クラス定義 ----------------------------------------------------------------*/