#include "mbed.h"
#include "BMX055.h"
#include "SDFileSystem.h"

SDFileSystem sd(PA_7, PA_6, PA_5, PA_4, "sd"); // the pinout on the mbed Cool Components workshop board
DigitalOut myled(LED1);

BMX055 bmx(PB_7,PB_6);//SDA,SCL
Serial pc(USBTX, USBRX);
double a[3],b[3],c[3];
int r;

int main() {
    mkdir("/sd/mydir00", 0777);
    FILE *fp = fopen("/sd/mydir00/sddata.csv", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    
    r=0;
    while(1000>r) {
        bmx.getAcc();
        bmx.getGyro();
        bmx.getMag();
        
    fprintf(fp,"%2.4f,%2.4f,%2.4f,%2.4f,%2.4f,%2.4f,%2.4f,%2.4f,%2.4f\n\r",(bmx.accel[0]/512)*9.8f,
        (bmx.accel[1]/512)*9.8f,(bmx.accel[2]/512)*9.8f,(bmx.gyroscope[0]*125)/2048.0f,
        (bmx.gyroscope[1]*125)/2048.0f,(bmx.gyroscope[2]*125)/2048.0f,bmx.magnet[0]/3.0f,bmx.magnet[1]/3.0f,bmx.magnet[2]/3.0f);
        
        pc.printf("%2.4f,%2.4f, %2.4f, %2.4f,%2.4f, %2.4f, %2.4f,%2.4f, %2.4f\r\n",bmx.accel[0],bmx.accel[1],bmx.accel[2],bmx.gyroscope[0],bmx.gyroscope[1],bmx.gyroscope[2],bmx.magnet[0],bmx.magnet[1],bmx.magnet[2]);
        //pc.printf("%2.4f, %2.4f, %2.4f, ",(bmx.accel[0]/512)*9.8,(bmx.accel[1]/512)*9.8,(bmx.accel[2]/512)*9.8);
        //pc.printf("%2.4f, %2.4f, %2.4f, ",(bmx.gyroscope[0]*125)/2048,(bmx.gyroscope[1]*125)/2048,(bmx.gyroscope[2]*125)/2048);       
        //pc.printf("%2.4f, %2.4f, %2.4f\r\n",bmx.magnet[0],bmx.magnet[1],bmx.magnet[2])
        r++;
    //    wait(0.2);
    }
    fclose(fp);
}
