#include "mbed.h"
#include "BMX055.h" 
#include "SDFileSystem.h"
#include "GPS.h"

GPS gps(PA_9, PA_10);       //TX(GPS_RX),RX(GPS_TX)
DigitalIn FlightPin(PB_0);

Serial pc(USBTX, USBRX, 9600);//パソコン側からもマイコン⇒IM920のデータはみれる
Serial uart(PA_2, PA_3, 19200);//TX(IM920_RX), RX(IM920_TX)

DigitalOut fet1(PA_8);       //MOSFET PIN:GATE
DigitalOut fet2(PA_11);
BMX055  bmx(PB_7,PB_6);//SDA,SCL
SDFileSystem sd(PA_7, PA_6, PA_5, PA_4, "sd"); // the pinout on the mbed Cool Components workshop board

Ticker warikomi;
Timeout t;
Timer t1;

//double a[3],b[3],c[3];
int i,j=0,rlock,mode;
char ns,ew;
float w_time;//,hokui,tokei;
float hokui,tokei;
float g_hokui,g_tokei;
float d_hokui,m_hokui,d_tokei,m_tokei;
char gps_data[256];
char str[256];


//void getGPS(float *hokui_n,float *tokei_n);
//void callback ();
void FlightPinDriver();
void nichrome_ON();
//void nichrome_OFF();
void buzzer(); 


int main() {
  //  float *hokui_n,*tokei_n;
    
    mkdir("/sd/mydir00", 0777);
    FILE *fp = fopen("/sd/mydir00/sddata.csv", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    
    //gps.baud(9600); 
    //pc.baud(9600);
    //gps.attach(getGPS(&hokui_n,&tokei_n),Serial::RxIrq);
    fprintf(fp,"N,E,acc:x,acc:y,acc:z,gyr:x,gyr:y,gyr:z,mag:x,mag:y,mag:z\r\n");
    //warikomi.attach(&FlightPinDriver,0.5);
    
   
    while(1) {       
        //BMX055部分
        
        if(FlightPin==1){
            printf("Flight Pin Worked!!\n\r");
            t1.start();
        //    warikomi.detach();
            }
        
        if(t1==3){   //ニクロム線作動までの時間
            printf("cut!\n\r");
            fet1=1;
            }
        
        if(t1==6){  //カット終了までの時間
            printf("cut finished");
            fet1=0;
            }
        
        if(t1==9){  //ブザー作動までの時間
            printf("buzzer");
            fet2=1;
            }
            
    
        bmx.getAcc();//加速度の取得
        bmx.getGyro();//角力加速度の取得
        bmx.getMag();//地磁気の取得
        int a[3],b[3],c[3];
        for(int i=0;i<3;i++){
            a[i]=bmx.accel[i];
            b[i]=bmx.gyroscope[i];
            c[i]=bmx.magnet[i];
            }        
        
        //GPS部分
        //gps.getgps();
        int x = (gps.longtitude-135.0f)*1000000;
        int y = (gps.latitude-34.0f)*1000000;
        if(gps.longtitude==NULL)x=0;
        if(gps.latitude==NULL)y=0;
        //int north=x * 1000000;
        //int east=y * 1000000;
        
        //SDカードへの書き込み
        fprintf(fp,"%f,%f,%f,%f,%f,%2.4f,%2.4f,%2.4f,%2.4f,%2.4f,%2.4f\n\r",gps.longtitude,gps.latitude,(a[0]/512)*9.8,
        (a[1]/512)*9.8f,(a[2]/512)*9.8f,(b[0]*125)/2048.0f,
        (b[1]*125)/2048.0f,(b[2]*125)/2048.0f,c[0]/3.0f,c[1]/3.0f,c[2]/3.0f);
        
        //IM920部分
        //ノード番号(00~FF)を設定.データを送るごとに1増やす．
        uart.printf("STNN %02x\r\n",j);
        j++;
        if(j==256){j=0;}
        
        uart.printf("TXDA ");//可変長データ送信コマンド
        
        uart.printf("%04hX%04hX%04hX",a[0],a[1],a[2]);//加速度の書き出し
        uart.printf("%04hX%04hX%04hX",b[0],b[1],b[2]);//角加速度の書き出し
        
        uart.printf("%08x%08x",x,y);//GPS書き出し
        
        uart.printf("\r\n");
        //printf("%d%d\n\r",north,east);

        wait(0.34);//IM920長距離モードの場合，3パケット/sが理論上最大速度．
        }
    }

/*void FlightPinDriver(){
    
    if(FlightPin==1){
            printf("Flight Pin Worked!!\n\r");
            //warikomi.detach();
            t.attach(nichrome_ON,3);//ニクロムを作動させるまでの時間
            }
        
        }

void nichrome_ON(){
    printf("cut!\n\r");
    fet1=1;
    t.detach();
    t.attach(nichrome_OFF,6);//ブザー作動までの時間
    }

void buzzer(){
    printf("buzzer\n\r");
    fet2=1;
    }*/