#include "mbed.h"
#include "BMX055.h" 
#include "SDFileSystem.h"

 

Serial gps(PA_9, PA_10);       // tx, rx
DigitalIn FlightPin(PB_0);

Serial pc(USBTX, USBRX, 19200);//パソコン側からもマイコン⇒IM920のデータはみれる
Serial uart(PA_2, PA_3, 19200);//TX(IM920_RX), RX(IM920_TX)

DigitalOut fet1(PA_8);       //MOSFET PIN:GATE
DigitalOut fet2(PA_11);
BMX055  bmx(PB_7,PB_6);//SDA,SCL
SDFileSystem sd(PA_7, PA_6, PA_5, PA_4, "sd"); // the pinout on the mbed Cool Components workshop board

Ticker warikomi;
Timeout t;
//double a[3],b[3],c[3];

int i,j=0,rlock,mode;
char ns,ew;
float w_time;//,hokui,tokei;
float hokui,tokei;
float g_hokui,g_tokei;
float d_hokui,m_hokui,d_tokei,m_tokei;
char gps_data[256];
char str[256];


void getGPS(float *hokui_n,float *tokei_n);
//void callback ();
void FlightPinDriver();
void nichrome_ON();
void buzzer(); 


int main() {
    
    float *hokui_n,*tokei_n;
    
    mkdir("/sd/mydir00", 0777);
    FILE *fp = fopen("/sd/mydir00/sddata.csv", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    
    gps.baud(9600); 
    //pc.baud(9600);
    //gps.attach(getGPS(&hokui_n,&tokei_n),Serial::RxIrq);
    //fprintf(fp,"N,E,acc:x,acc:y,acc:z,gyr:x,gyr:y,gyr:z,mag:x,mag:y,mag:z");
    warikomi.attach(&FlightPinDriver,0.5);
    
   
    while(1) {       
        //BMX055部分
        bmx.getAcc();//加速度の取得
        bmx.getGyro();//角力加速度の取得
        bmx.getMag();//地磁気の取得
        getGPS(hokui_n,tokei_n);//GPS取得
        
        if(*hokui_n==NULL){
            hokui_n=0;}
        if(*tokei_n==NULL){
            tokei_n=0;}
        //(fp,"%f,%f,%f,%f,%f,%2.4f,%2.4f,%2.4f,%2.4f,%2.4f,%2.4f\n\r",hokui_n,tokei_n,(bmx.accel[0]/512)*9.8,
        //(bmx.accel[1]/512)*9.8,(bmx.accel[2]/512)*9.8,(bmx.gyroscope[0]*125)/2048,
        //(bmx.gyroscope[1]*125)/2048,(bmx.gyroscope[2]*125)/2048,bmx.magnet[0],bmx.magnet[1],bmx.magnet[2]);
        int a[3],b[3],c[3];
        for(int i=0;i<3;i++){
            a[i]=bmx.accel[i];
            if(a[i]<0)a[i] += 4096;//負値の場合+4096
            b[i]=bmx.gyroscope[i];
            if(b[i]<0)b[i] += 4096;//負値の場合+4096
            c[i]=bmx.magnet[i];
            if(c[i]<0)c[i] += 4096;//負値の場合+4096
                     
            }
        //GPS部分
        
        //fprintf(fp,"北緯:%f,東経:%f,加速度:%f,%f,%f,ジャイロ:%2.4f,%2.4f,%2.4f\n\r",hokui_n,tokei_n,(bmx.accel[0]/512)*9.8,(bmx.accel[1]/512)*9.8,(bmx.accel[2]/512)*9.8,(bmx.gyroscope[0]*125)/2048,(bmx.gyroscope[1]*125)/2048,(bmx.gyroscope[2]*125)/2048);

        //IM920部分
        //ノード番号(00~FF)を設定.データを送るごとに1増やす．
        uart.printf("STNN %02x\r\n",j);
        j++;
        if(j==256){j=0;}
        
        uart.printf("TXDA ");//可変長データ送信コマンド
        
        uart.printf("%04x%04x%04x",a[0],a[1],a[2]);//加速度の書き出し
        uart.printf("%04x%04x%04x",b[0],b[1],b[2]);//角加速度の書き出し
        
        
        int north=*hokui_n * 1000000;
        int east=*tokei_n * 1000000;
        
        printf("%f",*hokui_n);
        
        uart.printf("%08x%08x",east,north);//GPS書き出し
        
        uart.printf("\r\n");
        printf("%d%d\n\r",north,east);

        wait(0.34);//IM920長距離モードの場合，3パケット/sが理論上最大速度．
        }
        
            
        //fclose(fp);
        
        return 0;
        
    }
        
        
void getGPS(float *hokui_n,float *tokei_n) {         //関数getGPS定義
            unsigned char c = gps.getc();
            if( c=='$' || i == 256){
                mode = 0;
                i = 0;
            }
            if(mode==0){
                if((gps_data[i]=c) != '\r'){
                i++;
            }else{
                gps_data[i]='\0';
                // pc.printf("%s\r\n",gps_data);
                if( sscanf(gps_data, "$GPGGA,%f,%f,%c,%f,%c,%d",&w_time,&hokui,&ns,&tokei,&ew,&rlock) >= 1){
                    if(rlock==1){
                          //  pc.printf("Status:Lock(%d)\n\r",rlock);
                            //logitude
                            d_tokei= int(tokei/100);
                            m_tokei= (tokei-d_tokei*100)/60;
                            g_tokei= d_tokei+m_tokei;
                            //pc.printf("Log:%4.5f,",g_tokei);                            //Latitude
                            d_hokui=int(hokui/100);
                            m_hokui=(hokui-d_hokui*100)/60;
                            g_hokui=d_hokui+m_hokui;
                            // pc.printf("Lat:%4.5f\n\r",g_hokui);
                                                  
                            *hokui_n=g_hokui;
                            *tokei_n=g_tokei;
            }
        //else{
          //pc.printf("\n\rStatus:unLock(%d)\n\r",rlock);
          //pc.printf("%s",gps_data);
        //}
      }//if
        *hokui_n=hokui;
        *tokei_n=tokei;
    }   //else
  }     //L.16 if
 }

/*void callback () {
    int i;
    char buf[65];

    //i = im920.recv(buf, 64);
    buf[i] = 0;
    printf("recv: '%s' (%d)\r\n", buf, i);
}*/

void FlightPinDriver(){
    
    if(FlightPin==1){
            printf("Flight Pin Worked!!\n\r");
            warikomi.detach();
            t.attach(nichrome_ON,3);//ニクロムを作動させるまでの時間
            }
        
        }

void nichrome_ON(){
    printf("テグスカット!\n\r");
    fet1=1;
    wait(2.0);//テグスを切るまでにかかる時間
    fet1=0;
    t.detach();
    t.attach(buzzer,6);//ブザー作動までの時間
    }

void buzzer(){
    printf("ブザー作動\n\r");
    fet2=1;
    }