#include "mbed.h"
#include "IM920.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
IM920 im920(PA_2,PA_3,PA_0,PA_1);//tx, rx, busy, reset

void callback () {
    int i;
    char buf[65];

    i = im920.recv(buf, 64);
    buf[i] = 0;
    printf("recv: '%s' (%d)\r\n", buf, i);
}

int main() {
    int i = 0;
    char buf[65];

    pc.baud(19200);
    pc.printf("*** IM920\r\n");
    im920.init();
    im920.attach(callback);
    myled = 1;
    
    for(i=0;i<64;i++){//bufにとりあえず値を入れてみる
        buf[i]=i;
        }
        
    //im920.poll();
    printf("send: %s\r\n", buf);//送信データの確認
    im920.send(buf,i);//データ送信

}
