#include "mbed.h"
#include "BMX055.h"

BMX055::BMX055(PinName SDA, PinName SCL) : bmx055(SDA,SCL)
{
    bmx055.frequency(100000);
    bmx_init();
}

void BMX055::bmx_init(void)
{
    char buf[2]= {0};
    printf("accel setting\r\n");
    buf[0]=0x14;
    buf[1]=0xB6;
    bmx055.write(ACC,buf,2);
    wait_ms(2);
    buf[0]=0x0F;//加速度の計測レンジの設定
    buf[1]=0x08;//
    bmx055.write(ACC,buf,2);
    buf[0]=0x10;
    buf[1]=0x0B;//加速度のODRとフィルターの帯域幅の設定，更新時間8ms
    bmx055.write(ACC,buf,2);
    buf[0]=0x11;
    buf[1]=0x00;
    bmx055.write(ACC,buf,2);
    wait_ms(2);

    printf("gyroscope setting\r\n");
    buf[0]=0x0F;
    buf[1]=0x04;//角加速度の計測レンジの設定
    bmx055.write(GYRO,buf,2);
    wait(0.1);
    buf[0]=0x10;
    buf[1]=0x06;//角加速度のODRとフィルターの帯域幅の設定，ODR:200Hz
    bmx055.write(GYRO,buf,2);
    wait(0.1);
    buf[0]=0x11;
    buf[1]=0x00;
    bmx055.write(GYRO,buf,2);
    wait(0.1);

    printf("magnet setting\r\n");
    buf[0]=0x4B;
    buf[1]=0x82;
    bmx055.write(MAG,buf,2);
    wait(0.1);
    buf[0]=0x4B;
    buf[1]=0x01;
    bmx055.write(MAG,buf,2);
    wait(0.1);
    buf[0]=0x4C;
    buf[1]=0x00;
    bmx055.write(MAG,buf,2);
    buf[0]=0x4E;
    buf[1]=0x84;
    bmx055.write(MAG,buf,2);
    buf[0]=0x51;
    buf[1]=0x04;
    bmx055.write(MAG,buf,2);
    buf[0]=0x52;
    buf[1]=0x16;
    bmx055.write(MAG,buf,2);
    wait(0.1);

    buf[0]=0x00;
    bmx055.write(MAG,buf,1,1);
    bmx055.read(MAG,buf,1);
    printf("read:0x%02x\r\n",buf[0]);
}

void BMX055::getAcc(void)
{
    uint8_t data[6]= {0};
    char reg = 0x02;
    bmx055.write(ACC,&reg,1,true);
    bmx055.read(ACC,(char*)data,6);

    for(int i=0; i<3; i++) {
        accel[i]=(int16_t)(((int16_t)data[i*2+1]<<8) | data[i*2]) >> 4;//ビット演算
    }
}

void BMX055::getGyro(void)
{
    uint8_t data[6]= {0};
    char reg = 0x02;
    bmx055.write(GYRO,&reg,1,true);
    bmx055.read(GYRO,(char*)data,6);

    for(int i=0; i<3; i++) {
        gyroscope[i]=(int16_t)(((int16_t)data[i*2+1]<<8) | data[i*2]);
    }
}

void BMX055::getMag(void)
{
    uint8_t data[8]= {0};
    char reg = 0x42;
    bmx055.write(MAG,&reg,1,true);
    bmx055.read(MAG,(char*)data,8);

    magnet[0]=(int16_t)(((int16_t)data[1]<<8) | data[0]) >> 3;
    magnet[1]=(int16_t)(((int16_t)data[3]<<8) | data[2]) >> 3;
    magnet[2]=(int16_t)(((int16_t)data[5]<<8) | data[4]) >> 1;
}
