#include "mbed.h"
#include "MCP3204.h"
#include "24LC1025.h"

Serial pc(PA_2, PA_3, 115200); //pin19,20 TX,RX
CAN can(PA_11, PA_12); //pin21,22 rd,td
SPI spi(PA_7, PA_6, PA_5);
MCP3204 mcp1(spi,PB_0); //下z-
MCP3204 mcp2(spi,PB_1); //右x+
MCP3204 mcp3(spi,PB_3); //左x-
MCP3204 mcp4(spi,PA_8); // 前y+
MCP3204 mcp5(spi,PA_10); //上z+
MCP3204 mcp6(spi,PF_0); //後y-
LC1025 eeprom = LC1025(PB_7, PB_6);
DigitalOut led(PB_5);

int rom_write(float);
int most_brightness(float,float,float,float);

Timer timer;
CANMessage msg;

#define T 0.03

float x=0.0,y=0.0,z=0.0;
float x_cal=0.0,y_cal=0.0,z_cal=0.0;
int i,j,m_bri,cnt=0,page_frg=0;
float world_time,t;
uint16_t eeprom_cnt = 0x0000;
char serialData[4];
int tf_mem =0;

union Float2Byte{
    float _float;
    char _byte[4];
};
typedef union Float2Byte Float2Byte;

union Int2Byte{
    unsigned short _int;
    char _byte[2];
};
typedef union Int2Byte Int2Byte;


void send(float senddata,int id){
    //pc.printf("Master send()\n\r");
    
    Float2Byte sendFloat;
    sendFloat._float = senddata;
    //ここに送りたい値を入れる．
    
    char serialData[4];
    for(int i=0;i<4;++i){
        serialData[i] = sendFloat._byte[i];
        //pc.printf("send_char: %d\n\r", serialData[i]);
    }
    //pc.printf("sendFloat: %f\n\r", sendFloat._float);
    if(can.write(CANMessage(id, serialData, 4))){
        //pc.printf("Send.\n\r");
    } 
}

void send2(unsigned short senddata1,unsigned short senddata2,unsigned short senddata3,int id){
    //pc.printf("Master send()\n\r");
    
    /*ID: 0x01*/
    Int2Byte sendInt;
    sendInt._int = senddata1;
    //ここに送りたい値を入れる．
    
    char serialData[6];

    serialData[0] = sendInt._byte[0];
    serialData[1] = sendInt._byte[1];
        //pc.printf("send_char: %d\n\r", serialData[i]);
    sendInt._int = senddata2;
    serialData[2] = sendInt._byte[0];
    serialData[3] = sendInt._byte[1];

    sendInt._int = senddata3;
    serialData[4] = sendInt._byte[0];
    serialData[5] = sendInt._byte[1];
    //pc.printf("sendFloat: %f\n\r", sendFloat._float);
    if(can.write(CANMessage(id, serialData, 6))){
        //pc.printf("Send.\n\r");
    } 
}

void receive(){
    Float2Byte getFloat;
    Int2Byte getInt;
    led = 0;
    
    if(can.read(msg)){
        //ID: 0x01
        if(msg.id == 0x01){
            //pc.printf("ID: 0x01\n\r");
            for(int i=0;i<4;++i){
                getFloat._byte[i] = msg.data[i];
                //pc.printf("get_char: %d\n\r", getFloat._byte[i]);
            }
            world_time = getFloat._float;
            //pc.printf("world_time:%.2f\r\n", world_time);
        }
        
        if(msg.id == 0x02){
            if(tf_mem == 0){
                tf_mem = 2;
                x=0.0f;
                y=0.0f;
                z=0.0f;
                timer.start();
                if(m_bri == 2) z_cal= 0.0;
                if(m_bri == 3) z_cal = 0 - 270.0f;
                if(m_bri == 4) z_cal = 0 - 180.0f;
                if(m_bri == 5) z_cal = 0 - 90.0f;
                pc.printf("ID: 0x02\n\r");
            }
        }
        
        if(msg.id == 0x03){
            //pc.printf("ID: 0x01\n\r");
            for(int i=0;i<4;++i){
                getFloat._byte[i] = msg.data[i];
                //pc.printf("get_char: %d\n\r", getFloat._byte[i]);
            }
            pc.printf("ID0x03:%.2f\r\n", getFloat._float);
        }
        
        if(msg.id == 0x04){
            //pc.printf("ID: 0x01\n\r");
            for(int i=0;i<4;++i){
                getFloat._byte[i] = msg.data[i];
                //pc.printf("get_char: %d\n\r", getFloat._byte[i]);
            }
            pc.printf("ID0x04:%.2f\r\n", getFloat._float);
        }
    }
    led=1;
    
}

int main(){
    int adc1[4],adc2[4],adc3[4],adc4[4],adc5[4],adc6[4];
    float ave[6],buff;
    
    can.attach(receive, CAN::RxIrq);
    pc.printf("Hello world%d\r\n",sizeof(i));
    led = 1;
    wait(1.0);
    *(float*)serialData=0.0f;
    for(i=0;i<10;i++){
        eeprom.PageWrite(ADDRESS_24LC1025_BLOCK0,eeprom_cnt,serialData,4);
        eeprom_cnt = 0x04 + eeprom_cnt;
        wait(0.1);
    }
    
    while(1){
        adc1[0] = mcp1.sgl( CH0 );
        adc1[1] = mcp1.sgl( CH1 );
        adc1[2] = mcp1.sgl( CH2 );
        adc1[3] = mcp1.sgl( CH3 );
        for(i=0;i<4-1;i++){
            for(j=1;j<4-i;j++){
                if(adc1[j-1] > adc1[j]){
                    buff = adc1[j-1];
                    adc1[j-1] = adc1[j];
                    adc1[j] = buff;
                }
            }
        }
        //pc.printf("%d,%d,%d,%d\r\n",adc1[0],adc1[1],adc1[2],adc1[3]);
        ave[0] = (adc1[1] + adc1[2])/2.0 + 120.0;
        
        adc2[0] = mcp2.sgl( CH0 );
        adc2[1] = mcp2.sgl( CH1 );
        adc2[2] = mcp2.sgl( CH2 );
        adc2[3] = mcp2.sgl( CH3 );
        for(i=0;i<4-1;i++){
            for(j=1;j<4-i;j++){
                if(adc2[j-1] > adc2[j]){
                    buff = adc2[j-1];
                    adc2[j-1] = adc2[j];
                    adc2[j] = buff;
                }
            }
        }
        //pc.printf("%d,%d,%d,%d\r\n",adc1[0],adc1[1],adc1[2],adc1[3]);
        ave[1] = (adc2[1] + adc2[2])/2.0;
        
        adc3[0] = mcp3.sgl( CH0 );
        adc3[1] = mcp3.sgl( CH1 );
        adc3[2] = mcp3.sgl( CH2 );
        adc3[3] = mcp3.sgl( CH3 );
        for(i=0;i<4-1;i++){
            for(j=1;j<4-i;j++){
                if(adc3[j-1] > adc3[j]){
                    buff = adc3[j-1];
                    adc3[j-1] = adc3[j];
                    adc3[j] = buff;
                }
            }
        }
        //pc.printf("%d,%d,%d,%d\r\n",adc1[0],adc1[1],adc1[2],adc1[3]);
        ave[2] = (adc3[1] + adc3[2])/2.0 + 70.0;
        
        adc4[0] = mcp4.sgl( CH0 );
        adc4[1] = mcp4.sgl( CH1 );
        adc4[2] = mcp4.sgl( CH2 );
        adc4[3] = mcp4.sgl( CH3 );
        for(i=0;i<4-1;i++){
            for(j=1;j<4-i;j++){
                if(adc4[j-1] > adc4[j]){
                    buff = adc4[j-1];
                    adc4[j-1] = adc4[j];
                    adc4[j] = buff;
                }
            }
        }
        //pc.printf("%d,%d,%d,%d\r\n",adc1[0],adc1[1],adc1[2],adc1[3]);
        ave[3] = (adc4[1] + adc4[2])/2.0 + 55.0;
        
        adc5[0] = mcp5.sgl( CH0 );
        adc5[1] = mcp5.sgl( CH1 );
        adc5[2] = mcp5.sgl( CH2 );
        adc5[3] = mcp5.sgl( CH3 );
        for(i=0;i<4-1;i++){
            for(j=1;j<4-i;j++){
                if(adc5[j-1] > adc5[j]){
                    buff = adc5[j-1];
                    adc5[j-1] = adc5[j];
                    adc5[j] = buff;
                }
            }
        }
        //pc.printf("%d,%d,%d,%d\r\n",adc1[0],adc1[1],adc1[2],adc1[3]);
        ave[4] = (adc5[1] + adc5[2])/2.0;
        
        adc6[0] = mcp6.sgl( CH0 );
        adc6[1] = mcp6.sgl( CH1 );
        adc6[2] = mcp6.sgl( CH2 );
        adc6[3] = mcp6.sgl( CH3 );
        for(i=0;i<4-1;i++){
            for(j=1;j<4-i;j++){
                if(adc6[j-1] > adc6[j]){
                    buff = adc6[j-1];
                    adc6[j-1] = adc6[j];
                    adc6[j] = buff;
                }
            }
        }
        //pc.printf("%d,%d,%d,%d\r\n",adc1[0],adc1[1],adc1[2],adc1[3]);
        ave[5] = (adc6[1] + adc6[2])/2.0 - 100.0;
        
        
        cnt = 0;
        
        t = timer.read();
        if(t > 1800){
            timer.reset();
        }
        //光姿勢判定
        for(i=0;i<6-1;i++){
            for(j=1;j<6-i;j++){
                if(ave[j-1] > ave[j]){
                    buff = adc6[j-1];
                    adc6[j-1] = adc6[j];
                    adc6[j] = buff;
                }
            }
        }
        //光姿勢判定
        m_bri = most_brightness(ave[2],ave[3],ave[4],ave[5]);
        
        if(ave[0] < ave[1]){
            x = 0.0f;
            y = 0.0f;
        }else{
            x = 180.0f;
            y = 0.0f;
        }
        
        if(m_bri == 2) z = z_cal;
        if(m_bri == 3) z = z_cal + 270.0f;
        if(m_bri == 4) z = z_cal + 180.0f;
        if(m_bri == 5) z = z_cal + 90.0f;
        
        if(z < 0.0f)z= z + 360.0f;
        
        z = (float)((int)(z*10.0f) % 3600)/10.0f;
        
        pc.printf("%d,%x,%f,%.1f,%.1f,%.1f,%.1f,%.1f,%.1f,%.1f,%.1f,%.1f,%d\r\n",page_frg,eeprom_cnt,t,ave[0],ave[1],ave[2],ave[3],ave[4],ave[5],x,y,z,m_bri);
        if(tf_mem != 2){
            send2((unsigned short)(0.0f*10.0f),(unsigned short)(0.0f*10.0f),(unsigned short)(0.0f*10.0f),6);
        }else{
            send2((unsigned short)(x*10.0f),(unsigned short)(y*10.0f),(unsigned short)(z*10.0f),6);
            
            for(i=0; i<6; i++){
                *(float*)serialData = ave[i];
                //pc.printf("%f,",ave[i]);
                if(eeprom_cnt > 0xFFF0){
                    page_frg++;
                    eeprom_cnt = 0;
                }
            
                if(page_frg == 0){
                    eeprom.PageWrite(ADDRESS_24LC1025_BLOCK0,eeprom_cnt,serialData,4);
                    //pc.printf("%d,0x%x,%.1f\r\n",page_frg,eeprom_cnt,ave[i]);
                }else if(page_frg == 1){
                    eeprom.PageWrite(ADDRESS_24LC1025_BLOCK1,eeprom_cnt,serialData,4);
                    //pc.printf("%d,0x%x\r\n",page_frg,eeprom_cnt);
                }else{
                    //pc.printf("EEPROM_ERROR!! You should erase memory\r\n");
                }
                eeprom_cnt = 0x04 + eeprom_cnt;
                wait(0.01);
            
            }
        
            rom_write(t);
            rom_write(x);
            rom_write(y);
            rom_write(z);
        }
        
        wait(0.03);
       
    }
    
}

int rom_write(float data){
    *(float*)serialData = data;
        if(eeprom_cnt > 0xFFF0){
            page_frg++;
            eeprom_cnt = 0;
        }
          
        if(page_frg == 0){
            eeprom.PageWrite(ADDRESS_24LC1025_BLOCK0,eeprom_cnt,serialData,4);
            //pc.printf("%d,0x%x,%.1f\r\n",page_frg,eeprom_cnt,ave[i]);
        }else if(page_frg == 1){
            eeprom.PageWrite(ADDRESS_24LC1025_BLOCK1,eeprom_cnt,serialData,4);
            //pc.printf("%d,0x%x\r\n",page_frg,eeprom_cnt);
        }else{
            //pc.printf("EEPROM_ERROR!! You should erase memory\r\n");
        }
        eeprom_cnt = 0x04 + eeprom_cnt;
        wait(0.01);
        return 0;
}

int most_brightness(float data_mae_2,float data_migi_3,float data_usiro_4,float data_hidari_5){
    int re_num;
    if(data_mae_2 < data_migi_3){
        if(data_mae_2 < data_usiro_4){
            if(data_mae_2 < data_hidari_5){
                re_num = 2;
            }else{
                re_num = 5;
            }
        }else if(data_usiro_4 < data_hidari_5){
            re_num = 4;
        }else{
            re_num = 5;
        }
    }else if(data_migi_3 < data_usiro_4){
        if(data_migi_3 < data_hidari_5){
            re_num = 3;
        }else{
            re_num = 5;
        }
    }else{
        if(data_usiro_4 < data_hidari_5){
            re_num = 4;
        }else{
            re_num = 5;
        }
    }
    return re_num;
}