/*
CAN通信master側
2種類のIDで送信する．
rd - RXD
td - TXD
MCP2551まわりは以下参照(終端Rは410ohmを使った，そこにあったので)
https://raw.githubusercontent.com/rummanwaqar/teensy_can/master/schematic.png
*/
#include "mbed.h"

Serial pc(PA_9, PA_10, 115200); //pin19,20 TX,RX
CAN can(PA_11, PA_12,100000); //pin21,22 rd,td
DigitalOut myled(PB_1); //pin15
Ticker ticker;

CANMessage msg;

AnalogIn L1(PA_0);
AnalogIn L2(PA_1);
AnalogIn L3(PA_3);
AnalogIn L4(PA_4);
AnalogIn L5(PA_5);

union Float2Byte{
    float _float;
    char _byte[4];
};
typedef union Float2Byte Float2Byte;

void send(float senddata,int id){
    //pc.printf("Master send()\n\r");
    
    /*ID: 0x01*/
    Float2Byte sendFloat;
    sendFloat._float = senddata;
    //ここに送りたい値を入れる．
    
    char serialData[4];
    for(int i=0;i<4;++i){
        serialData[i] = sendFloat._byte[i];
        //pc.printf("send_char: %d\n\r", serialData[i]);
    }
    //pc.printf("sendFloat: %f\n\r", sendFloat._float);
    if(can.write(CANMessage(id, serialData, 4))){
        pc.printf("Send.\n\r");
    } 
    
    
    myled = !myled;
}

void receive(){
    Float2Byte getFloat;
    
    if(can.read(msg)){
        /*ID: 0x01*/
        if(msg.id == 0x01){
            //pc.printf("ID: 0x01\n\r");
            for(int i=0;i<4;++i){
                getFloat._byte[i] = msg.data[i];
                //pc.printf("get_char: %d\n\r", getFloat._byte[i]);
            }
            pc.printf("%.2f\r\n", getFloat._float);
            myled = !myled;
        }
        /*ID: 0x02*/
        if(msg.id == 0x02){
            //pc.printf("ID: 0x02\n\r");
            for(int i=0;i<4;++i){
                getFloat._byte[i] = msg.data[i];
                //pc.printf("get_char: %d\n\r", getFloat._byte[i]);
            }
            pc.printf("avarage: %.0f\n\r", getFloat._float);
            myled = !myled;
        }
    }
}

int main(){
    float meas_r[5];
    float meas_v[5];
    float sum = 0.0;
    int i;
    
    pc.printf("Master_start.\n\r");
    //ticker.attach(&send, 1);
    can.attach(receive, CAN::RxIrq);
    while(1) {
        sum = 0.0;

        meas_r[0] = L1.read();
        meas_r[1] = L2.read();
        meas_r[2] = L3.read();
        meas_r[3] = L4.read();
        meas_r[4] = L5.read();

        for(i=0;i<5;i++){    
            meas_v[i] = meas_r[i] * 3300; // Converts value in the 0V-3.3V range
            //pc.printf("%d:%.0f,", i+1,meas_v[i]);
            //send(meas_v[i],0x01);
            sum += meas_v[i];
            //wait(0.05);
            
        }
        wait(0.1);
        pc.printf("%.0f\r\n",sum/5.0);
        send(0,0x01);
    }
}