#include "mbed.h"
#include "QEI.h"
#include "PS3.h"

PS3 ps3(PA_0,PA_1);
I2C i2c(D14,D15);
Serial pc(USBTX,USBRX);
QEI arm_enc(PB_5, PB_4, NC, 624);

DigitalIn kaisyu_mae(D3);
DigitalIn kaisyu_usiro(D2);
DigitalIn tyokudo_mae(A3);
DigitalIn tyokudo_usiro(A2);

char init_send_data[1];
char arm_moter[1],drop_moter[1];

int phase = 1;
int kaisyu_phase = 0;
int tyokudo_phase = 0;

void kaisyu(int but, int pulse);
void tyokudo(int but,int pulse);

int main(void)
{
    kaisyu_mae.mode(PullUp);
    kaisyu_usiro.mode(PullUp);
    tyokudo_mae.mode(PullUp);
    tyokudo_usiro.mode(PullUp);
    init_send_data[0] = 0x80;
    i2c.write(0x18, init_send_data, 1);
    i2c.write(0x20, init_send_data, 1);
    while(1) {
        switch(phase) {
            case 1:
                kaisyu(maru,arm_enc.getPulses());
                break;
            case 2:
                tyokudo(sikaku,arm_enc.getPulses());
                break;

        }
    }
}



void kaisyu(int but, int pulse)
{
    //一回ボタン押したら動くやつ(危険)
    if(kaisyu_mae == 0 && kaisyu_usiro == 1 && kaisyu_phase == 0) {
        kaisyu_phase = ps3.getButtonState(but);
    }
    switch (kaisyu_phase) {
        case 0:
            arm_moter[0] = 0x80;
            kaisyu_phase = 0;
            break;
        case 1:
            //前進->減速
            if(pulse < 2000) {
                arm_moter[0] = 0xFF;
                kaisyu_phase = 1;
            } else {
                arm_moter[0] = 0xB3;
                kaisyu_phase = 2;
            }
            break;
        case 2:
            //前進->停止->後進
            if(kaisyu_usiro == 1) {
                arm_moter[0] = 0xB3;
                kaisyu_phase = 2;
            } else {
                arm_moter[0] =  0x80;
                kaisyu_phase = 3;
                i2c.write(0x18, arm_moter,1);
                wait(1);
            }
            break;
        case 3:
            //後進->減速
            if(pulse > 1600) {
                arm_moter[0] = 0x00;
                kaisyu_phase = 3;
            } else {
                arm_moter[0] = 0x4C;
                kaisyu_phase = 4;
            }
            break;
        case 4:
            //後進->停止
            if(kaisyu_mae == 1) {
                arm_moter[0] = 0x4C;
                kaisyu_phase = 4;
            } else {
                arm_moter[0] = 0x80;
                kaisyu_phase = 0;
                phase = 2;
            }
            break;
        default:
            break;
    }
    i2c.write(0x18, arm_moter,1);
}

void tyokudo(int but,int pulse)
{
    //一回ボタン押したら動くやつ(危険)
    if(tyokudo_mae == 1 && tyokudo_usiro == 0 && tyokudo_phase == 0) {
        tyokudo_phase = ps3.getButtonState(but);
    }
    switch (tyokudo_phase) {
        case 0:
            arm_moter[0] = 0x80;
            drop_moter[0] = 0x80;
            break;
        case 1:
            //前進->減速
            arm_moter[0] = (pulse < 2000)? 0xCD:0xC0;
            drop_moter[0] = (pulse < 2000)? 0xE6:0xCD;
            tyokudo_phase = (pulse < 2000)? 1:2;
            break;
        case 2:
            //前進(遅い)->停止->後進(早い)
            if(tyokudo_mae == 1) {
                arm_moter[0] = 0xC0;
                drop_moter[0] = 0xCD;
                tyokudo_phase = 2;
            } else {
                arm_moter[0] = 0x80;
                drop_moter[0] = 0x80;
                tyokudo_phase = 3;
                i2c.write(0x18, arm_moter,1);
                i2c.write(0x20, drop_moter,1);
                wait(1);
            }
            break;
        case 3:
            //後進->減速
            arm_moter[0] = (pulse > 1600)? 0x33:0x33;
            drop_moter[0] = (pulse > 1600)? 0x19:0x19;
            tyokudo_phase = (pulse > 1600)? 3:4;
            break;
        case 4:
            //後進->停止
            arm_moter[0] = (tyokudo_usiro == 1)? 0x33:0x80;
            drop_moter[0] = (tyokudo_usiro == 1)? 0x19:0x80;
            tyokudo_phase = (tyokudo_usiro == 1)? 4:0;
            break;
        default:
            arm_moter[0] = 0x80;
            drop_moter[0] = 0x80;
            tyokudo_phase = 0;
            break;
    }
    i2c.write(0x18, arm_moter,1);
    i2c.write(0x20, drop_moter,1);
}