#include "mbed.h"
#include "QEI.h"
#include "Help.h"

Serial pc(USBTX,USBRX);
QEI arm_enc(PA_6, PA_8, NC, 624);

int direct,speed;
char wheel_RF = SBREAK;
char wheel_LF = SBREAK;
char wheel_RB = SBREAK;
char wheel_LB = SBREAK;
char arm_moter = SBREAK;
char dp_moter = SBREAK;
char rsheet_moter = SBREAK;
char lsheet_moter = SBREAK;

int main(void)
{
    speed = fast;
    direct = SBREAK;
    set_gpio();
    write_data(Rf_add,SBREAK);
    write_data(Lf_add,SBREAK);
    write_data(Rb_add,SBREAK);
    write_data(Lb_add,SBREAK);
    write_data(Arm_add,SBREAK);
    write_data(Dp_add,SBREAK);
    write_data(Rst_add,SBREAK);
    write_data(Lst_add,SBREAK);
    write_data(Fan_add,SBREAK);
    while(1) {
        set_emg();
        set_direct(&direct);
        set_speed(&speed);
        set_arm(&arm_moter, cir,arm_enc.getPulses());
        set_drop(&dp_moter, squ, cro);
        set_sheet(&rsheet_moter,'R',up,dow);
        set_sheet(&lsheet_moter,'L',up,dow);
        if(direct != 0) {
            set_tire(&wheel_RF, &wheel_RB, direct, 'R', speed);
            set_tire(&wheel_LF, &wheel_LB, direct, 'L', speed);
        } else {
            set_slide(&wheel_RF,&wheel_LF,&wheel_RB,&wheel_LB,r1,l1, speed);
        }
        arm_moter = (dp_moter != SBREAK)? dp_moter:arm_moter;

        write_data(Rf_add,wheel_RF);
        write_data(Lf_add,wheel_LF);
        write_data(Rb_add,wheel_RB);
        write_data(Lb_add,wheel_LB);
        write_data(Arm_add,arm_moter);
        write_data(Dp_add,dp_moter);
        write_data(Dp_add,dp_moter);
        write_data(Dp_add,dp_moter);

        pri("\033[2J");
        pri("\033[1;1H 0x%x:%d",arm_moter,arm_enc.getPulses());
        pri("\033[2;1H 0x%x",dp_moter);
        pri("\033[3;1H 0x%x",rsheet_moter);
        pri("\033[4;1H 0x%x",lsheet_moter);
        /*
        pri("\033[2J");
        pri("\033[1;1H wheel_RF:0x%x",wheel_RF);
        pri("\033[2;1H wheel_LF:0x%x",wheel_LF);
        pri("\033[3;1H wheel_RB:0x%x",wheel_RB);
        pri("\033[4;1H wheel_LB:0x%x",wheel_LB);
        pri("\033[5;1H arm_moter:0x%x",arm_moter);
        pri("\033[6;1H direct:%d",direct);
        pri("\033[7;1H speed:%d",speed);
        */

    }
}