#include "Help.h"
#include "PS3.h"

PS3 ps3(PA_0,PA_1);
I2C i2c(D14,D15);
DigitalOut POWER_LED(D5);
DigitalOut flag(D6);
DigitalIn arm_mae(A3);
DigitalIn arm_usiro(A2);
DigitalIn drop_mae(D3);
DigitalIn drop_usiro(D2);
int motion_phase;

void set_gpio(void)
{
    POWER_LED = 1;
    arm_mae.mode(PullUp);
    arm_usiro.mode(PullUp);
    drop_mae.mode(PullUp);
    drop_usiro.mode(PullUp);
}

void set_emg(void)
{
    bool start  = ps3.getSTARTState();
    bool select = ps3.getSELECTState();

    flag = (select == 0 && start == 1)? 0:flag;
    flag = (select == 1 && start == 1)? 1:flag;
    flag = (select == 1 && start == 0)? 1:flag;
}

void get_stick(int *axis,char mode)
{
    switch (mode) {
        case 'R':
            *axis = ps3.getRightJoystickXaxis();
            ++axis;
            *axis = ps3.getRightJoystickYaxis();
            break;
        case 'L':
            *axis = ps3.getLeftJoystickXaxis();
            ++axis;
            *axis = ps3.getLeftJoystickYaxis();
            break;
    }
}

bool get_but(int butnum)
{
    int ps3_cases[12] = {38,36,16,37,32,33,34,35,19,20,17,18};//sign,cross,rl
    return ps3.getButtonState(ps3_cases[butnum]);
}

void set_speed(int *pspeed)
{
    *pspeed = (get_but(r2) && get_but(l2))? low:*pspeed;
    *pspeed = (ps3.getSTARTState())? fast:*pspeed;
}

void set_direct(int *direct)
{
    get_stick(Raxis,'R');
    get_stick(Laxis,'L');
    int Rrad = atan2(double(Raxis[1]), double(Raxis[0]))*double(180/PI);
    int Lrad = atan2(double(Laxis[1]), double(Laxis[0]))*double(180/PI);
    *direct = SBREAK;
    *direct = (Rrad == 0 && Lrad == 0)? 0:*direct;
    *direct = (Rrad >= 45 && Rrad <= 135)? 1:*direct;
    *direct = (Rrad <= -45 && Rrad >= -135)? 2:*direct;
    *direct = (Rrad > -45 && Rrad < 0)||(Rrad > 0 && Rrad < 45)||(Raxis[0] == 63 && Raxis[1] == 0)? 3:*direct;
    *direct = (Rrad > 135) || (Rrad > -180 && Rrad < -135)? 4:*direct;
    *direct = (Rrad > 0 && get_but(r1))? 5:*direct;
    *direct = (Rrad > 0 && get_but(l1))? 6:*direct;
}

void set_tire(char *fmot, char *bmot, int direct, char mode, int speed)
{
    int front = SBREAK;
    int back = SBREAK;
    front = (speed == low)? pDuty50:pDuty70;
    back = (speed == low)?  nDuty50:nDuty70;
    switch (direct) {
        case 1:
            *fmot = front;
            *bmot = front;
            break;
        case 2:
            *fmot = back;
            *bmot = back;
            break;
        case 3:
            *fmot = (mode == 'R')? back:front;
            *bmot = (mode == 'R')? back:front;
            break;
        case 4:
            *fmot = (mode == 'R')? front:back;
            *bmot = (mode == 'R')? front:back;
            break;
        case 5:
            if(speed == low) {
                *fmot = (mode == 'R')? front:front+TRANSIT;
                *bmot = (mode == 'R')? front:front+TRANSIT;
            } else if(speed == fast) {
                *fmot = (mode == 'R')? front-TRANSIT:front;
                *bmot = (mode == 'R')? front-TRANSIT:front;
            }
            break;
        case 6:
            if(speed == low) {
                *fmot = (mode == 'L')? front:front+TRANSIT;
                *bmot = (mode == 'L')? front:front+TRANSIT;
            } else if(speed == fast) {
                *fmot = (mode == 'L')? front-TRANSIT:front;
                *bmot = (mode == 'L')? front-TRANSIT:front;
            }
            break;
        case 0:
        default :
            *fmot = SBREAK;
            *bmot = SBREAK;
            break;
    }
}

void set_slide(char *Rfmot,char *Lfmot,char *Rbmot,char *Lbmot,int but1,int but2, int speed)
{
    int front = SBREAK;
    int back = SBREAK;
    front = (speed == low)? pDuty50:pDuty70;
    back = (speed == low)? nDuty50:nDuty70;
    if(get_but(but1) ^ get_but(but2)) {
        int butnum = (get_but(but1) > get_but(but2))? but1:but2;
        switch (butnum) {
            case r1:
            case r2:
                *Rfmot = back;
                *Lfmot = front;
                *Rbmot = front;
                *Lbmot = back;
                break;
            case l1:
            case l2:
                *Rfmot = front;
                *Lfmot = back;
                *Rbmot = back;
                *Lbmot = front;
                break;
        }
    } else {
        *Rfmot = SBREAK;
        *Lfmot = SBREAK;
        *Rbmot = SBREAK;
        *Lbmot = SBREAK;
    }
}

void set_mot(char *mot,int num1,int num2)
{
    *mot = SBREAK;
    if(get_but(num1) != get_but(num2)) {
        int butnum = (get_but(num1) > get_but(num2))? num1:num2;
        switch (butnum) {
            case cir:
                *mot = (arm_mae == 1)? pDuty85:SBREAK;
                break;
            case cro:
                *mot = (arm_usiro == 1)? nDuty85:SBREAK;
                break;
        }
    }
}

void set_arm(char *mot, int num, int pulse)
{
    //押しっぱなしで動くやつ(まだましさだまさし)
    //motion_phase = get_but(num);

    //一回ボタン押したら動くやつ(危険)
    if(arm_mae == 0 && arm_usiro == 1) {
        motion_phase = get_but(num);
    }

    switch (motion_phase) {
        case 0:
            *mot = SBREAK;
            motion_phase = 0;
            break;
        case 1://前進->減速
            *mot = (pulse < 2000)? pDuty90:pDuty40;
            motion_phase = (pulse < 2000)? 1:2;
            break;
        case 2://前進->後進
            //*mot = (arm_usiro == 1)? pDuty40:nDuty80;
            if(arm_usiro == 1) {
                *mot = pDuty40;
                motion_phase = 2;
            } else {
                char send_data[1] =  {SBREAK};
                motion_phase = 3;
                i2c.write(Arm_add, send_data,     1, false);
                wait(2);
            }
            //motion_phase = (arm_usiro == 1)? 2:3;
            break;
        case 3://後進->減速
            *mot = (pulse > 1600)? nDuty90:nDuty40;
            motion_phase = (pulse > 1600)? 3:4;
            break;
        case 4://後進->停止
            *mot = (arm_mae == 1)? nDuty40:SBREAK;
            motion_phase = (arm_mae == 1)? 4:0;
            break;
        default:
            *mot = SBREAK;
            motion_phase = 0;
            break;

    }
}

void set_drop(char *mot, int num1,int num2)
{
    *mot = SBREAK;
    if(get_but(num1) != get_but(num2)) {
        int butnum = (get_but(num1) > get_but(num2))? num1:num2;
        switch (butnum) {
            case squ:
                *mot = (drop_mae == 1)? pDuty85:SBREAK;
                break;
            case cro:
                *mot = (drop_usiro == 1)? nDuty85:SBREAK;
                break;
        }
    }
}

void set_sheet(char *mot,char mode, int num1, int num2)
{
    *mot = SBREAK;
    if(get_but(num1) != get_but(num2)) {
        int butnum = (get_but(num1) > get_but(num2))? num1:num2;
        switch (butnum) {
            case up:
                *mot = (mode == 'R')? pDuty85:nDuty85;
                break;
            case dow:
                *mot = (mode == 'R')? nDuty85:pDuty85;
                break;
        }
    }

}

void write_data(char address,char data)
{
    char send_data[1] =  {data};
    i2c.write(address, send_data,     1, false);
}