#ifndef Help_H
#define Help_H
#include "mbed.h"

#define nDuty10 0x74
#define nDuty20 0x66
#define nDuty25 0x60
#define nDuty30 0x59
#define nDuty40 0x4C
#define nDuty50 0x40
#define nDuty60 0x33
#define nDuty70 0x26
#define nDuty75 0x20
#define nDuty85 0x13
#define nDuty80 0x19
#define nDuty90 0x0C
#define nDuty95 0x00

#define pDuty10 0x8C
#define pDuty20 0x99
#define pDuty25 0x9F
#define pDuty30 0xA6
#define pDuty40 0xB3
#define pDuty50 0xC0
#define pDuty60 0xCD
#define pDuty70 0xD9
#define pDuty75 0xE0
#define pDuty80 0xE6
#define pDuty85 0xEC
#define pDuty90 0xF3
#define pDuty95 0xFF

#define SBREAK  0x80
#define TRANSIT 0x30

#define Rf_add 0x10
#define Rb_add 0x12
#define Lf_add 0x14
#define Lb_add 0x16
#define Arm_add 0x18
#define Dp_add 0x20
#define Rst_add 0x22
#define Lst_add 0x24
#define Fan_add 0x26

#define cir 0
#define tri 1
#define squ 2
#define cro 3
#define up  4
#define dow 5
#define rig 6
#define lef 7
#define r1  8
#define r2  9
#define l1  10
#define l2  11
#define low 1
#define fast 3

#define pri pc.printf

void set_gpio(void);
void get_stick(int *axis,char mode);
bool get_but(int butnum);
void set_speed(int *pspeed);
void set_direct(int *direct);
void set_emg(void);
void set_tire(char *fmot,char *bmot,int direct, char mode, int speed);
void set_slide(char *Rfmot,char *Lfmot,char *Rbmot,char *Lbmot, int but1,int but2, int speed);
void set_mot(char *mot,int num1,int num2);
void set_arm(char *mot,int num, int pulse);
void set_drop(char *mot,int num1, int num2);
void set_sheet(char *mot, char mode,int num1, int num2);
void write_data(char address,char data);
static int Raxis[2],Laxis[2];

#endif