#include "EC.h"
#include "R1370P.h"
#include "move4wheel.h"
#include "mbed.h"
#include "math.h"
#include "PathFollowing.h"
#include "movement.h"
#include "maxonsetting.h"
#include "DCsetting.h"


/*---------------------使用モーターの種類を選択(maxonsetting.cpp / DCsetting.cpp / movement.cppでも同様に選択)-----------------------*/
//#define DC_MOTOR_MODE //DCモーター
#define MAXON_MOTOR_MODE //マクソンモーター
/*----------------------------------------------------------------------------------------------------------------------------*/


/*---------------------ESCONの使用有無を選択------------------------*/
#define ESCON_USE_MODE //ESCON使用
//#define ESCON_DISUSE_MODE //ESCON不使用
/*---------------------------------------------------------------*/


/*---------------------プログラムモードの選択------------------------*/
//#define NHK2020_DEBUG_MODE //デバッグ用（パソコン操作）
#define NHK2020_TEST_MODE //試走用
//#define NHK2020_MAIN_MODE //本番用
/*---------------------------------------------------------------*/


/*------------------使用プログラムの情報を出力-----------------------*/
//#define PROGRAM_INFO
/*---------------------------------------------------------------*/


/*------------運動時の各速度の設定----------*/
double st_speed = 500; // 移動開始時の速度
double max_speed = 2500; // 直線移動時の最大速度
double mid_speed = 2000; // 直線移動時の中間速度
double turn_speed = 1000; // 旋回時の速度
double end_speed = 200; // 停止直前の速度
/*--------------------------------------*/


//-----mbed led------------------//点灯条件-----------------------//参照場所------------------------------//
//DigitalOut debug_led(LED3);    //maxon debug programme -> on  //maxonsetting.cpp


Serial pc(USBTX,USBRX);

//////////////////////////////////////////////////////////////以下main文/////////////////////////////////////////////////////////////////

int main()
{

    UserLoopSetting_maxon();
    UserLoopSetting_sensor();
    UserLoopSetting_enc();

#ifdef PROGRAM_INFO //プログラム使用時に使用プログラムの情報を最初に表示

    printf("ソースファイル名 : %s¥n", __FILE__);
    printf("作成日付 : %s¥n", __DATE__);
    printf("作成時刻 : %s¥n", __TIME__);

#endif


/*-------------------------------------------デバッグ用プログラム-----------------------------------------------*/
#ifdef NHK2020_DEBUG_MODE

    static char pc_command = '\0';
    int md = 0;

    while(1) {
        pc_command = pc.getc();

        if(pc_command == 'w') { //"w"を押すと全モーターを正方向に加速
            md += 500;
        } else if(pc_command == 's') { //"s"を押すと全モーターを負方向に加速
            md -= 500;
        }

#ifdef MAXON_MOTOR_MODE
        MaxonControl(dm,dm,dm,dm);
#endif
#ifdef DC_MOTOR_MODE
        DCControl(dm,dm,dm,dm);
#endif
    }
#endif
/*-------------------------------------------------------------------------------------------------------*/


/*-------------------------------------------試走用プログラム-----------------------------------------------*/
#ifdef NHK2020_TEST_MODE

    //spline_curve(0,0,100,50,30,0,70,50,10);
    spline_curve(0,0,100,50,30,0,70,50,10);
    //straight(1,1,0,0,1000,0,5000,5000,5,0.1,10,0.1,600,0);
    //MaxonControl(0,0,0,0);

#endif
/*-------------------------------------------------------------------------------------------------------*/


/*-------------------------------------------本番用プログラム-----------------------------------------------*/
#ifdef NHK2020_MAIN_MODE


#endif
/*-------------------------------------------------------------------------------------------------------*/
}
