#include "EC.h"
#include "R1370P.h"
#include "move4wheel.h"
#include "mbed.h"
#include "math.h"
#include "PathFollowing.h"
#include "movement.h"
#include "manual.h"
#include "can.h"

#include <ros.h>
#include <geometry_msgs/Point.h>
#include <geometry_msgs/Pose.h>

ros::NodeHandle nh;
geometry_msgs::Point posi_xyr;
geometry_msgs::Quaternion usw_4info;

ros::Publisher pub_xyr("/mbed_main1",&posi_xyr);
ros::Publisher pub_usw("/mbed_main2",&usw_4info);

Ticker cm_pc;
#define PI 3.141592

void cm_to_pc(){
    
    copy_xyr_usw();
    
    posi_xyr.x = info_x;
    posi_xyr.y = info_y;
    posi_xyr.z = info_r;
    
    usw_4info.x = usw_data1;
    usw_4info.y = usw_data2;
    usw_4info.z = usw_data3;
    usw_4info.w = usw_data4;
    
    pub_xyr.publish(&posi_xyr);
    pub_usw.publish(&usw_4info);
}


//-----mbed led------------------//点灯条件-----------------------//参照場所------------------------------//
//DigitalOut cansend_led(LED1);  //cansend -> on                //can.cpp
//DigitalOut canread_led(LED2);  //canread -> on                //can.cpp
//DigitalOut debug_led(LED3);    //maxon debug programme -> on  //maxonsetting.cpp

//////////////////////////////////////////////////////////////以下main文/////////////////////////////////////////////////////////////////

int main()
{
    nh.getHardware()->setBaud(115200);
    nh.initNode();
    nh.advertise(pub_xyr);
    nh.advertise(pub_usw);
    
    cm_pc.attach(&cm_to_pc,0.01);

    UserLoopSetting_sensor();
    
    while(1) {

        nh.spinOnce();
        wait(0.01);

    }

}