#include "mbed.h"
  #include "EC.h" //Encoderライブラリをインクルード
  #include "SpeedController.h"    //SpeedControlライブラリをインクルード
  #define RESOLUTION 2048
  #define BASIC_SPEED 1
  #define TEST_DUTY 0.3
  
Ec4multi EC_kagawa(PA_5,PC_9,RESOLUTION);
SpeedControl kagawa(PB_9,PB_8,50,EC_kagawa);
Ec4multi EC_tokusima(PA_15,PA_14,RESOLUTION);
SpeedControl tokusima(PC_7,PA_6,50,EC_tokusima);
Ec4multi EC_kouchi(PC_13,PB_7,RESOLUTION);
SpeedControl kouchi(PA_9,PB_6,50,EC_kouchi);
Ec4multi EC_ehime(PC_2,PC_3,RESOLUTION);
SpeedControl ehime(PB_3,PA_10,50,EC_ehime);

//Ec4multi EC_1(PA_5,PC_9,RESOLUTION);//
//Ec4multi EC_2(PA_5,PC_9,RESOLUTION);

Ticker motor_tick;  //角速度計算用ticker
Serial pc(USBTX,USBRX);


  int main(){
      kagawa.period_us(50);
      tokusima.period_us(50);
      kouchi.period_us(50);
      ehime.period_us(50);
      kagawa.setEquation(0.0252,0.1500,-0.0361,0.1500);    //求めたC,Dの値を設定
      kagawa.setPDparam(0,0.0);  //PIDの係数を設定
      tokusima.setEquation(0.0302,0.0755,-0.0241,0.1301);    //求めたC,Dの値を設定
      tokusima.setPDparam(0,0.0);  //PIDの係数を設定
      kouchi.setEquation(0.0302,0.1500,-0.0301,0.2000);    //求めたC,Dの値を設定
      kouchi.setPDparam(0,0.0);  //PIDの係数を設定
      ehime.setEquation(0.0302,0.0755,-0.0301,0.1001);    //求めたC,Dの値を設定
      ehime.setPDparam(0,0.0);  //PIDの係数を設定



          int kai=0;
    double target_kagawa=0,target_tokusima=0,target_kouchi=0,target_ehime=0;
    char status[5][10]= {"STOP","FORWARD","BACKWARD","RIGHT","LEFT"};
    int status_num=0;         //初期状態は停止

    while(1) {
        if(target_kagawa==0) kagawa.stop();
        else kagawa.Sc(target_kagawa);
        if(target_tokusima==0) tokusima.stop();
        else tokusima.Sc(target_tokusima);
        if(target_kouchi==0) kouchi.stop();
        else kouchi.Sc(target_kouchi);
        if(target_ehime==0) ehime.stop();
        else ehime.Sc(target_ehime);
        if(kai>=4) {
            //printf("\r\n");
            printf("target:%.2f,%.2f.%.2f,%.2f",target_kagawa,target_tokusima,target_kouchi,target_ehime);
            printf("status=%s omega_=%.2f,%.2f,%.2f,%.2f \r\n",status[status_num],EC_kagawa.getOmega(),EC_tokusima.getOmega(),EC_kouchi.getOmega(),EC_ehime.getOmega());
          
            //機体の進む方向、右モーターの角速度、左モーターの角速度を表示
            kai=0;
        }
        
        if(pc.readable()) {
            char sel=pc.getc();

            switch (sel) {
                case 's':           //停止
                    kagawa.stop();
                    tokusima.stop();
                    kouchi.stop();
                    ehime.stop();
                    target_kagawa=0;
                    target_tokusima=0;
                    target_kouchi=0;
                    target_ehime=0;
                    status_num=0;
                    break;
                case 'i':           //前進
                    target_kagawa=1*BASIC_SPEED;
                    target_tokusima=1*BASIC_SPEED;
                    target_kouchi=-1*BASIC_SPEED;
                    target_ehime=-1*BASIC_SPEED;
                    status_num=1;
                    break;
                case 'm':           //後退
                    target_kagawa=-1*BASIC_SPEED;
                    target_tokusima=-1*BASIC_SPEED;
                    target_kouchi=1*BASIC_SPEED;
                    target_ehime=1*BASIC_SPEED;
                    status_num=2;
                    break;
                case 'k':           //ccw
                    target_kagawa=1*BASIC_SPEED;
                    target_tokusima=1*BASIC_SPEED;
                    target_kouchi=1*BASIC_SPEED;
                    target_ehime=1*BASIC_SPEED;
                    status_num=3;
                    break;
                case 'j':           //cw
                    target_kagawa=-1*BASIC_SPEED;
                    target_tokusima=-1*BASIC_SPEED;
                    target_kouchi=-1*BASIC_SPEED;
                    target_ehime=-1*BASIC_SPEED;
                    status_num=4;
                    break;
                default:
                    break;
            }
            if(sel=='q') {
                break; //qを押したら左右のモーターを停止
            }
        }
        kai++;
    }
    kagawa.stop();
    tokusima.stop();
    kouchi.stop();
    ehime.stop();

    return 0;
}

/*
      while(1){
          kagawa.turn(0.95);    //dutyで正転
          tokusima.turn(-0.65);    //dutyで正転
          kouchi.turn(0.8);    //dutyで正転
          ehime.turn(-0.85);    //dutyで正転
          wait(2);
          
          kagawa.turn(0);      //停止
          tokusima.turn(0);      //停止
          kouchi.turn(0);      //停止
          ehime.turn(0);      //停止
          wait(5);
          kagawa.turn(-0.8);  //dutyで逆転
          tokusima.turn(0.8);  //dutyで逆転
          kouchi.turn(-0.8);  //dutyで逆転
          ehime.turn(0.8);  //dutyで逆転
          wait(1);
          
          kagawa.turn(0);      //停止
          tokusima.turn(0);      //停止
          kouchi.turn(0);      //停止
          ehime.turn(0);      //停止
          wait(5);
      }
}
*/