//モーターの角速度(x)とduty比(y)の関係を
//y=Cx+Dであると近似した時の、定数Dを決定するためのプログラム
//モーターがギリギリ動き始める点を探し、その点を切片としてDを決定する
//入力はTera Termで行う
//4wheel ver
#include "mbed.h"
#include "EC.h" //Encoderライブラリをインクルード
#include "SpeedController.h"
#define RESOLUTION 2048 //分解能
#define BASIC_SPEED 1 //目標角速度、1から動かさない方がいい(多分)
//#define TEST_DUTY 0.3
  
Ec4multi EC_kagawa(PA_5,PC_9,RESOLUTION);
SpeedControl kagawa(PB_9,PB_8,50,EC_kagawa);
Ec4multi EC_tokusima(PA_15,PA_14,RESOLUTION);
SpeedControl tokusima(PC_7,PA_6,50,EC_tokusima);
Ec4multi EC_kouchi(PC_13,PB_7,RESOLUTION);
SpeedControl kouchi(PA_9,PB_6,50,EC_kouchi);
Ec4multi EC_ehime(PC_2,PC_3,RESOLUTION);
SpeedControl ehime(PB_3,PA_10,50,EC_ehime);
Serial pc(USBTX,USBRX);
Ticker motor_tick;
 
/*void calOmega(){
    motor.CalOmega();    //角速度計算用
}
 */
int main(void){
// motor_tick.attach(calOmega,0.05);
    int loop_time=0;
    double kagawa_duty=0;
    double tokusima_duty=0;
    double kouchi_duty=0;
    double ehime_duty=0;
    bool print=false;
 
    while(1){
        loop_time++;
 
        kagawa.turn(kagawa_duty); //
        tokusima.turn(tokusima_duty); //
        kouchi.turn(kouchi_duty); //
        ehime.turn(ehime_duty); //
 
 
        if(pc.readable()){
            char sel=pc.getc();
            if(sel=='s'){
                kagawa.stop();
                tokusima.stop();
                kouchi.stop();
                ehime.stop();
            } else if(sel=='e'){
                kagawa_duty+=(float)0.02;        //eを押すとduty比がo.o2ずつあがる
                pc.printf("duty=%f\r\n",kagawa_duty);
            } else if(sel=='d'){
                kagawa_duty-=(float)0.02;        //dを押すとduty比がo.o2ずつさがる
                pc.printf("duty=%f\r\n",kagawa_duty);
            }else if(sel=='r'){
                tokusima_duty+=(float)0.02;        //rを押すとduty比がo.o2ずつあがる
                pc.printf("duty=%f\r\n",tokusima_duty);
            } else if(sel=='f'){
                tokusima_duty-=(float)0.02;        //fを押すとduty比がo.o2ずつさがる
                pc.printf("duty=%f\r\n",tokusima_duty); 
            }else if(sel=='t'){
                kouchi_duty+=(float)0.02;        //tを押すとduty比がo.o2ずつあがる
                pc.printf("duty=%f\r\n",kouchi_duty);
            } else if(sel=='g'){
                kouchi_duty-=(float)0.02;        //gを押すとduty比がo.o2ずつさがる
                pc.printf("duty=%f\r\n",kouchi_duty);
            }else if(sel=='y'){
                ehime_duty+=(float)0.02;        //yを押すとduty比がo.o2ずつあがる
                pc.printf("duty=%f\r\n",ehime_duty);
            } else if(sel=='h'){
                ehime_duty-=(float)0.02;        //hを押すとduty比がo.o2ずつさがる
                pc.printf("duty=%f\r\n",ehime_duty);
            }else if(sel=='p'){
                print=!print;                //pを押すと表示を停止/再開する
            }
        }
 
        if(loop_time%1000==0){
            if(print) pc.printf("%.2f %.2f %.2f %.2f\r\n",EC_kagawa.getOmega(),EC_tokusima.getOmega(),EC_kouchi.getOmega(),EC_ehime.getOmega());
        }   //
    }
}
