#include"mbed.h"
#include"math.h"

PwmOut RF(PA_4);//right motor forward
PwmOut RB(PA_7);//right motor back

PwmOut LF(PA_3);//left motor forward
PwmOut LB(PA_1);//left motor back

PwmOut U(PA_11);//bace up
PwmOut D(PB_4);//bace down

PwmOut servo(PA_10);//arm right and left

AnalogIn x_axis(PB_0);//joystick X
AnalogIn y_axis(PB_1);//joistick Y

DigitalIn buttonU(PA_8,PullUp);//bace up
DigitalIn buttonD(PF_1,PullUp);//bace down
DigitalIn buttonRL(PF_0,PullUp);//arm right and left

void motor(double U,double D,double RF,double RB,double LF,double LB)
{
}
int main()
{
    RF.period_ms(20);
    RB.period_ms(20);
    LF.period_ms(20);
    LB.period_ms(20);
    U.period_ms(20);
    D.period_ms(20);
    servo.period_ms(20);

    double x,y;
    int arm = 1; //where is the arm 0(=0) or 1(=90) or 2(=180)

    while(1) {
        //「ここからベースの上下処理」
        if(buttonU.read()==0 && buttonD.read()==1) {
            wait(0.05); //チャタリング
            if(buttonU.read()==0 && buttonD.read()==1) {
                U=0;
                D=0.95;
                printf("down");
            }
        } else if(buttonU.read()==1 && buttonD.read()==0) {
            wait(0.05); //チャタリング
            if(buttonU.read()==1 && buttonD.read()==0) {
                U=0.95;
                D=0;
                printf("up");
            }
        } else {
            U=0;
            D=0;
        }
        //「ここまでベースの上下処理」
        //「ここからアームの左右処理」
        if(buttonRL.read()==0) { //タクトが押されているかの処理 「ここからアームの開閉処理」
            wait(0.05);                //チャタリング？の処理
            if(buttonRL.read()==0) { //タクトが押されているかの処理
                if(arm == 1) {
                    servo.pulsewidth_us(600);
                    wait(0.5);
                    arm = 0;
                    printf("left");
                } else  {
                    if(arm == 0) {
                        servo.pulsewidth_us(2300);
                        wait(0.5);
                        arm = 2 ;
                        printf("right");
                    }  else  {
                        if(arm == 2) {
                            servo.pulsewidth_us(1450);
                            wait(0.5);
                            arm = 1 ;
                            printf("middle");
                        }
                    }//「ここまでアームの左右処理」
                    x  = -(x_axis.read()-0.5)*2;
                    y  = -(y_axis.read()-0.5)*2;
                    printf("x,y=%f,%f\r\n",x,y);
                    if(-0.2<x && x<0.2 && -0.2<y && y<0.2) {
                        RF=0;
                        RB=0;
                        LF=0;
                        LB=0;
                        printf("0");
                    } else if(x<=-0.2 && 0.2<=y) {
                        RF=sqrt(x*x+y*y)-0.1;
                        RB=0;
                        LF=-x/2+0.1;
                        LB=0;
                        printf("1");
                    } else if(-0.2<x && x<0.2 && 0.2<y) {
                        RF=sqrt(x*x+y*y)/2+0.1;
                        RB=0;
                        LF=sqrt(x*x+y*y)/2+0.45;
                        LB=0;
                        printf("2");
                    } else if(0.2<=x && 0.2<=y) {
                        RF=x/2-0.1;
                        RB=0;
                        LF=sqrt(x*x+y*y)-0.1;
                        LB=0;
                        printf("3");
                    } else if(0.2<x && -0.2<y && y<0.2) {
                        RF=0;
                        RB=sqrt(x*x+y*y)/2+0.1;
                        LF=sqrt(x*x+y*y)/2+0.45;
                        LB=0;
                        printf("4");
                    } else if(0.2<=x && y<=-0.2) {
                        RF=0;
                        RB=x/2-0.1;
                        LF=0;
                        LB=sqrt(x*x+y*y)-0.1;
                        printf("5");
                    } else if(-0.2<x && x<0.2 && y<-0.2) {
                        RF=0;
                        RB=sqrt(x*x+y*y)/2+0.1;
                        LF=0;
                        LB=sqrt(x*x+y*y)/2+0.45;
                        printf("6");
                    } else if(x<=-0.2 && y<=-0.2) {
                        RF=0;
                        RB=sqrt(x*x+y*y)-0.1;
                        LF=0;
                        LB=-x/2+0.1;
                        printf("7");
                    } else if(x<-0.2 && -0.2<y && y<0.2) {
                        RF=sqrt(x*x+y*y)/2+0.1;
                        RB=0;
                        LF=0;
                        LB=sqrt(x*x+y*y)/2+0.45;
                        printf("8");
                    } else {
                        printf("10");
                    }
                }
            }
        }
    }
}
