//
//  Sample "SaberTooth_serial"
//  2012/10/06 created by matsuo@edu.teu.ac.jp
//  2014/06/13 revised by matsuo@edu.teu.ac.jp

#include "mbed.h"

//AnalogIn aIn_1(p19);    // Command input 1(0.0 to 1.0).
//AnalogIn aIn_2(p20);    // Command input 2(0.0 to 1.0).

Serial pc(USBTX, USBRX); // tx, rx for PC terminal.
Serial sabertooth(p28, p27);  // tx, rx for Sabertooth.
double moterDeg;
double deg[3];


void getDeg()
{
    deg[0]=pc.getc()-48;
    deg[1]=pc.getc()-48;
    deg[2]=pc.getc()-48;
    
    moterDeg=deg[0]+deg[1]*0.1+deg[2]*0.01;
    pc.printf("%lf\t",moterDeg);
    }

int main()
{
    sabertooth.baud(19200); // Set baudrate of serial port for Sabertooth.
    int cmd_1=0;
    sabertooth.putc(0);   // Send "Stop" to Motor 1 and 2.
    pc.attach(getDeg,Serial::RxIrq);
    while (1) {
        cmd_1 = (int)(moterDeg * 126 + 1); // Convert aIn_1 from 0.0-1.0 to 1-127.
        //cmd_2 = (int)(aIn_2*126+128); // Convert aIn_2 from 0.0-1.0 to 128-255.

        sabertooth.putc(cmd_1);   // Output cmd_1 to Motor 1.
        //sabertooth.putc(cmd_2);   // Output cmd_2 to Motor 2.

        pc.printf("%d\t", cmd_1);

        wait_ms(10);
    }
}