#include "mbed.h"
#include "Math.h"
#include "EC.h"
#include "SpeedController.h"
DigitalOut cylinder(p9);
DigitalOut cylindert(p10);
AnalogIn LBR1(p17,PullUp);
AnalogIn LBR2(p18,PullUp);
AnalogIn LBR3(p19,PullUp);
AnalogIn LBR4(p20,PullUp);
PwmOut servo12(p21);
PwmOut servo3(p22);
PwmOut motor1(p25);
PwmOut motor2(p26);
DigitalOut motor1cw(p27);
DigitalOut motor2cw(p28);

Ec ec1 (p12,p11,NC,500,0.05)
Ec ec2 (p14,p13,NC,500,0.05)

/*直進用*/
void straight(int x)  //x=車輪の移動距離(mm)
{
    mortor1.period_us(50);
    mortor2.period_us(50);
    ec1.setDiameter_mm(150);
    ec2.setDiameter_mm(150);
    ec1.reset();
    ec2.reset();
    double EC1_distance = ec1.getDistance_mm ();
    double EC2_distance = ec2.getDistance_mm ();
    while(fabs(EC1_distance) <= x && fabs(EC2_distance) <= x) {
        motor1 = ; //モータ1への出力
        motor2 = ; //モータ2への出力
        motor1cw = ; //モータ1の回転方向
        motor2cw = ; //モータ2の回転方向
    }
}

/*後退用*/
void back(int x)  //x=車輪の移動距離(mm)
{
    mortor1.period_us(50);
    mortor2.period_us(50);
    ec1.setDiameter_mm(150);
    ec2.setDiameter_mm(150);
    ec1.reset();
    ec2.reset();
    double EC1_distance = ec1.getDistance_mm ();
    double EC2_distance = ec2.getDistance_mm ();
    while(fabs(EC1_distance) <= x && fabs(EC2_distance) <= x) {
        motor1 = ; //モータ1への出力
        motor2 = ; //モータ2への出力
        motor1cw = ; //モータ1の回転方向
        motor2cw = ; //モータ2の回転方向
    }
}

/*右回転*/
void right(int x)  //x=車輪の移動距離(mm)
{
    mortor1.period_us(50);
    mortor2.period_us(50);
    ec1.setDiameter_mm(150);
    ec2.setDiameter_mm(150);
    ec1.reset();
    ec2.reset();
    double EC1_distance = ec1.getDistance_mm ();
    double EC2_distance = ec2.getDistance_mm ();
    while(fabs(EC1_distance) <= x && fabs(EC2_distance) <= x) {
        motor1 = ; //モータ1への出力
        motor2 = ; //モータ2への出力
        motor1cw = ; //モータ1の回転方向
        motor2cw = ; //モータ2の回転方向
    }
}

/*左回転*/
void left(int x)  //x=車輪の移動距離(mm)
{
    mortor1.period_us(50);
    mortor2.period_us(50);
    ec1.setDiameter_mm(150);
    ec2.setDiameter_mm(150);
    ec1.reset();
    ec2.reset();
    double EC1_distance = ec1.getDistance_mm ();
    double EC2_distance = ec2.getDistance_mm ();
    while(fabs(EC1_distance) <= x && fabs(EC2_distance) <= x) {
        motor1 = ; //モータ1への出力
        motor2 = ; //モータ2への出力
        motor1cw = ; //モータ1の回転方向
        motor2cw = ; //モータ2の回転方向
    }
}

int main()
{
}