/****************************************************
*            FAST PROTOTYPING WITH NUCLEO           *
* Example Code 13: Ultrasound HCSR04                *
* Author: Mauro D'Angelo                            *
* Organization: Perlatecnica no-profit organization *  
*****************************************************/

#include "mbed.h"
#include "hcsr04.h"

// Instanzio un oggetto di tipo HCSR04 ed assegno i pin di trigger e di echo 
HCSR04 sensor(PB_8, PB_9);

// Serial
Serial pc(USBTX, USBRX);
 
int main() {
    // Fisso il baudrate
    pc.baud(9600);
    
    // Main loop
    while(1) {
        // Avvia un impulso della durata di 10us sul pin di trigger
        sensor.start();
        
        // Aspetta prima della prossima lettura
        wait_ms(100); 
        
        // Stampa sulla seriale la misura della distanza in cm
        pc.printf("%dcm\r\n", sensor.get_dist_cm());
    }
}
