/****************************************************
*            FAST PROTOTYPING WITH NUCLEO           *
* Example Code 12: Servo motor control              *
* Author: Mauro D'Angelo                            *
* Organization: Perlatecnica no-profit organization *  
*****************************************************/

#include "mbed.h"
#include "rtos.h"

#define PWMB PA_7
#define DIRB PA_5

#define PWMA PB_3
#define DIRA PA_6


// Instanzia un oggetto di tipo PwmOut  e gli da il nome mypwm
PwmOut mypwm(PWMA);
// Definisce il pin che indica la direzione
DigitalOut motordir(DIRB);

// Instanzia un oggetto di tipo DigitalOut sul pin LED1 e gli da il nome myled
DigitalOut myled(LED1);

// Instanzia un oggetto di tipo AnalogIn e gli da nome analog_value. A questo viene assegnato un pin di ingresso analogico
AnalogIn analog_value(A0);

float meas;
float dutycycle;

// Instanzia un oggetto di tipo Serial sui pin Tx e Rx della porta USB e gli da il nome pc (trattandosi della porta USB connessa al PC)
Serial pc(USBTX, USBRX);

// Read variable resistor
void runmotor_threadfunc(void const *args) {
    while(true){
      meas = analog_value.read(); // Reads the analog input value (value from 0.0 to 1.0)
      printf("measure = %.2f \r\n", meas);
      //printf("pwm set to %.2f %%\r\n", mypwm.read() * 100);
      dutycycle = meas*2/1000;
       // Set PWM period
      mypwm.period_ms(20+dutycycle); 
      mypwm.pulsewidth(dutycycle);
   }
}

// Entry point
int main() { 
    // Set direction
    motordir = 1; 
   
     
    // Start Thread 
    Thread runmotor_thread(runmotor_threadfunc); 
    
    while(1) {;}
}