/****************************************************
*            FAST PROTOTYPING WITH NUCLEO           *
* Example Code 06: Variable resistor                *
* Author: Mauro D'Angelo                            *
* Organization: STMicroelectronics                  *  
*****************************************************/

#include "mbed.h"

// Instanzia un oggetto di tipo AnalogIn che chiamo analog_value, e lo assegna al pin A0 
AnalogIn analog_value(A0);
BusOut      Bar(PC_8,PC_6,PC_5,PA_12,PA_11,PB_12,PB_2,PB_1,PB_15,PB_14);
DigitalOut led(LED1);

int main() {
    float meas;
    
    while(1) {
        meas = analog_value.read(); // It reads the analog input value (value from 0.0 to 1.0)
  
 //      int i=int(10*meas);
 //     
        meas = meas * 3300; // Change the value to be in the 0 to 3300 range
    float i=(meas/330);
          printf("intero  = %.2f \r\n", i);
        printf("measure = %.2f mV\r\n", meas);
    
   //      printf("calcolo i  = %.2f mV\r\n", i);
        int j=int(i);
         printf("valore j  = %d\n", j);
        Bar =1<<j;
        if (meas < 2500) { // If the value is greater than 2V then switch the LED on
         led = 1;
        }
        else {
          led = 0;
        }
        wait(.1); // 200 ms
    }
}
