#include "Utils.h"
#include "USBHost.h"
#include "hci.h"
#include "ps3.h"
#include "User.h"
#include "mbed.h"

int RSX,RSY,LSX,LSY,BSU,BSL;
//これより下に関数外に書く要素を記入する
//spi通信用
SPI spi(p5,p6,p7);
DigitalOut cs(p8);


void UserLoopSetting()
{
    spi.format(16,3);
    spi.frequency(1000000);
}

void UserLoop(char n,const u8* data)
{
    u16 ButtonState;
    if(n==0) { //有線Ps3USB.cpp
        RSX = ((ps3report*)data)->RightStickX;
        RSY = ((ps3report*)data)->RightStickY;
        LSX = ((ps3report*)data)->LeftStickX;
        LSY = ((ps3report*)data)->LeftStickY;
        BSU = (u8)(((ps3report*)data)->ButtonState & 0x00ff);
        BSL = (u8)(((ps3report*)data)->ButtonState >> 8);
        //ボタンの処理
        ButtonState =  ((ps3report*)data)->ButtonState;
    } else {//無線TestShell.cpp
        RSX = ((ps3report*)(data + 1))->RightStickX;
        RSY = ((ps3report*)(data + 1))->RightStickY;
        LSX = ((ps3report*)(data + 1))->LeftStickX;
        LSY = ((ps3report*)(data + 1))->LeftStickY;
        BSU = (u8)(((ps3report*)(data + 1))->ButtonState & 0x00ff);
        BSL = (u8)(((ps3report*)(data + 1))->ButtonState >> 8);
        //ボタンの処理
        ButtonState =  ((ps3report*)(data + 1))->ButtonState;
    }
    //ここより下にプログラムを書く
    //spi通信用プログラム

    int a,b,c,d,e,f,g,h,i,j;
    int send = 0;


    while(1) {
        if((ButtonState >> BUTTONTRIANGEL)&1 == 1) { //フォトトランジスタ１
            a = 1;
        } else {
            a = 0;
        }

        if((ButtonState >> BUTTONCIRCLE)&1 == 1) {//フォトトランジスタ２
            b = 2;
        } else {
            b = 0;
        }

        if((ButtonState >> BUTTONUP)&1 == 1) {//対応するボタンを書く(今回上ボタン
            c = 4;
        } else {
            c = 0;
        }

        if((ButtonState >> BUTTONDOWN)&1 == 1) {//対応するボタンを書く(今回下ボタン
            d = 8;
        } else {
            d = 0;
        }

        if((ButtonState >> BUTTONL1)&1 == 1) {//対応するボタンを書く(今回L1ボタン
            e = 16;
        } else {
            e = 0;
        }

        if((ButtonState >> BUTTONL2)&1 == 1) {//対応するボタンを書く(今回L2ボタン
            f = 32;
        } else {
            f = 0;
        }

        if((ButtonState >> BUTTONTRIANGEL)&1 == 1) {//対応するボタンを書く(今回△ボタン
            g = 64;
        } else {
            g = 0;
        }

        if((ButtonState >> BUTTONCROSS)&1 == 1) {//対応するボタンを書く(今回×ボタン
            h = 128;
        } else {
            h = 0;
        }

        if((ButtonState >> BUTTONR1)&1 == 1) {//対応するボタンを書く(今回R1ボタン
            i = 256;
        } else {
            i = 0;
        }

        if((ButtonState >> BUTTONR2)&1 == 1) {//対応するボタンを書く(今回R2ボタン
            j = 512;
        } else {
            j = 0;
        }



        send = a+b+c+d+e+f+g+h+i+j;

        cs = 0;
        spi. write(send);
        cs = 1;
        printf("%d\r\n",send);

    }
}