#include "Utils.h"
#include "USBHost.h"
#include "hci.h"
#include "ps3.h"
#include "User.h"

#include "mbed.h"

int RSX,RSY,LSX,LSY,BSU,BSL;
//これより下に関数外に書く要素を記入する


//moter Pwm*2
//右足
PwmOut pin_ueasi_1(p25);
PwmOut pin_ueasi_2(p26);
//左足
PwmOut pin_sitaasi_1(p23);
PwmOut pin_sitaasi_2(p24);

//moter Pwm*1 DigitalOut*2//
//採取腕//
PwmOut pin_pick_1(p22);
DigitalOut pin_pick_2(p20);
DigitalOut pin_pick_3(p19);
//振幅腕//
PwmOut pin_lift_1(p21);
DigitalOut pin_lift_2(p18);
DigitalOut pin_lift_3(p17);

double ue_speed=0.9;
double sita_speed=1;
double pick_speed=1;
double lift_speed=1;


void UserLoopSetting()
{
    //一度だけ行いたい初期設定をここに書く
}

void UserLoop(char n,const u8* data)
{
    u16 ButtonState;
    if(n==0) { //有線Ps3USB.cpp
        RSX = ((ps3report*)data)->RightStickX;
        RSY = ((ps3report*)data)->RightStickY;
        LSX = ((ps3report*)data)->LeftStickX;
        LSY = ((ps3report*)data)->LeftStickY;
        BSU = (u8)(((ps3report*)data)->ButtonState & 0x00ff);
        BSL = (u8)(((ps3report*)data)->ButtonState >> 8);
        //ボタンの処理
        ButtonState =  ((ps3report*)data)->ButtonState;
    } else {//無線TestShell.cpp
        RSX = ((ps3report*)(data + 1))->RightStickX;
        RSY = ((ps3report*)(data + 1))->RightStickY;
        LSX = ((ps3report*)(data + 1))->LeftStickX;
        LSY = ((ps3report*)(data + 1))->LeftStickY;
        BSU = (u8)(((ps3report*)(data + 1))->ButtonState & 0x00ff);
        BSL = (u8)(((ps3report*)(data + 1))->ButtonState >> 8);
        //ボタンの処理
        ButtonState =  ((ps3report*)(data + 1))->ButtonState;
    }
    //ここより下にプログラムを書く

    //ーー足回りーー
    //右足
    if((ButtonState >> BUTTONRANALOG)&1 == 1)
        ue_speed=0.9;
    else
        ue_speed=0.45;
    if(RSY>=0 && RSY<=80) { //正回転
        pin_ueasi_1=ue_speed;
        pin_ueasi_2=0;

    } else if(RSY>=150&&RSY<=255) { //負回転
        pin_ueasi_1=0;
        pin_ueasi_2=ue_speed;
    } else { //停止
        pin_ueasi_1=0;
        pin_ueasi_2=0;
    }



    //左足
    if((ButtonState >> BUTTONLANALOG)&1 == 1)
        sita_speed=1;
    else
        sita_speed=0.5;
    if(LSY>=0 && LSY<=80) {//正回転
        pin_sitaasi_1=0;
        pin_sitaasi_2=sita_speed;
    } else if(LSY>=150 && LSY<=255) { //負回転
        pin_sitaasi_1=sita_speed;
        pin_sitaasi_2=0;
    } else { //停止
        pin_sitaasi_1=0;
        pin_sitaasi_2=0;
    }




    //採取腕
    if((ButtonState >> BUTTONR1)&1 == 1) {//掴み
        pin_pick_1=pick_speed;
        pin_pick_2=0;
        pin_pick_3=1;
    } else if((ButtonState >> BUTTONR2)&1 == 1) { //離し
        pin_pick_1=pick_speed;
        pin_pick_2=1;
        pin_pick_3=0;
    } else { //停止
        pin_pick_1=0;
        pin_pick_2=0;
        pin_pick_3=1;
    }

    //振幅腕
    if((ButtonState >> BUTTONL1)&1 == 1) {//上昇
        pin_lift_1=lift_speed;
        pin_lift_2=1;
        pin_lift_3=0;



    } else if((ButtonState >> BUTTONL2)&1 == 1) { //下降
        pin_lift_1=lift_speed;
        pin_lift_2=0;
        pin_lift_3=1;
        pin_pick_1=pick_speed;
        pin_pick_2=0;
        pin_pick_3=1;

    } else { //停止
        pin_lift_1=0;
        pin_lift_2=1;
        pin_lift_3=0;
    }


//〇ボタンで一個掃き出し
    if((ButtonState >> BUTTONCIRCLE)&1 == 1) {
        //離し
        pin_pick_1=pick_speed;
        pin_pick_2=1;
        pin_pick_3=0;
        wait(0.45);
        //誤差修正
        pin_pick_1=pick_speed;
        pin_pick_2=0;
        pin_pick_3=1;
        wait(0.4);


    }


    //十字キー
    if((ButtonState >> BUTTONUP)&1 == 1) {//上ボタン 前進
        pin_ueasi_1=0.85;
        pin_ueasi_2=0;
        pin_sitaasi_1=0;
        pin_sitaasi_2=1;
    }
    if((ButtonState >> BUTTONDOWN)&1 == 1) {//下ボタン　後進
        pin_ueasi_1=0;
        pin_ueasi_2=0.85;
        pin_sitaasi_1=1;
        pin_sitaasi_2=0;
    }
    if((ButtonState >> BUTTONRIGHT)&1 == 1) {//右ボタン　右旋回
        pin_ueasi_1=0;
        pin_ueasi_2=0.85;
        pin_sitaasi_1=0;
        pin_sitaasi_2=1;
    }
    if((ButtonState >> BUTTONLEFT)&1 == 1) {//左ボタン　左旋回
        pin_ueasi_1=0.85;
        pin_ueasi_2=0;
        pin_sitaasi_1=1;
        pin_sitaasi_2=0;
    }


    //△ボタンで自動振幅腕
    if((ButtonState >> BUTTONTRIANGEL)&1 == 1) {
        //上昇
        pin_lift_1=lift_speed;
        pin_lift_2=1;
        pin_lift_3=0;
        wait(3.8);
        
        }






        //データ取得例

        //値の取得はps3.hを参照
        //ここまでプログラム例    実機に乗せるときは消して大丈夫です


    }
