#include "mbed.h"
#include "I2C_SSD1306Z.h" 
#include "BME280.h"


I2C i2c(I2C_SDA, I2C_SCL);
BME280 sensor(PB_3, PB_10);
 
DigitalOut myled(LED1);
Serial pc(SERIAL_TX, SERIAL_RX);

int main()
{

    char tbuffer[50], hpbuffer[50], hbuffer[50];
    printf("init oled\n");
    
    Init_LCD();
    clear_LCD();
 
  while (1) {
     

     
     sprintf(tbuffer, "Temp: %2.2f degC", sensor.getTemperature());
     sprintf(hpbuffer, "P: %4.2f hPa", sensor.getPressure());
     sprintf(hbuffer, "Hum: %2.2f %%", sensor.getHumidity()); 
     
     tbuffer[strlen(tbuffer)] = '\0';
     hpbuffer[strlen(hpbuffer)] = '\0';
     hbuffer[strlen(hbuffer)] = '\0';
     
     print_Line(0, tbuffer);
     print_Line(1, hpbuffer);
     print_Line(2, hbuffer);
      

     wait(2.0);
     clear_LCD();

   }

}


